% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{calculate_probabilities}
\alias{calculate_probabilities}
\title{Calculate dose-path probabilities}
\usage{
calculate_probabilities(dose_paths, true_prob_tox, true_prob_eff = NULL, ...)
}
\arguments{
\item{dose_paths}{Object of type \code{\link{dose_paths}}}

\item{true_prob_tox}{Numeric vector, true probability of toxicity.}

\item{true_prob_eff}{vector of true efficacy probabilities, optionally NULL
if efficacy not analysed.}

\item{...}{Extra parameters}
}
\description{
Crystallise a set of \code{\link{dose_paths}} with probabilities to calculate
how likely each path is. Once probabilised in this way, the probabilities of
the terminal nodes in this set of paths will sum to 1. This allows users to
calculate operating characteristics.
}
\examples{
# Phase 1 example.
# Calculate dose paths for the first three cohorts in a 3+3 trial of 5 doses:
paths <- get_three_plus_three(num_doses = 5) \%>\%
  get_dose_paths(cohort_sizes = c(3, 3, 3))

# Set the true probabilities of toxicity
true_prob_tox <- c(0.12, 0.27, 0.44, 0.53, 0.57)
# And calculate exact operating performance
x <- paths \%>\% calculate_probabilities(true_prob_tox)
prob_recommend(x)

# Phase 1/2 example.
prob_select = c(0.1, 0.3, 0.5, 0.07, 0.03)
selector_factory <- get_random_selector(prob_select = prob_select,
                                        supports_efficacy = TRUE)
paths <- selector_factory \%>\% get_dose_paths(cohort_sizes = c(2, 2))
true_prob_eff <- c(0.27, 0.35, 0.41, 0.44, 0.45)
x <- paths \%>\% calculate_probabilities(true_prob_tox = true_prob_tox,
                                       true_prob_eff = true_prob_eff)
prob_recommend(x)
}
\seealso{
\code{\link{dose_paths}}
}
