% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastextract.R
\name{fastextract}
\alias{fastextract}
\title{Fast raster extraction at points (buffered)}
\usage{
fastextract(x, y, d = 0, w = "circle", fun = "mean", na.rm = TRUE)
}
\arguments{
\item{x}{SpatRaster. Input raster (single- or multi-layer).}

\item{y}{SpatVector. Points or polygons.}

\item{d}{numeric or numeric vector. Buffer radius/radii in map units.}

\item{w}{character. Window type for the buffer kernel when \code{d > 0}
(currently passed through to \pkg{terra}; e.g., "circle", "rectangle").}

\item{fun}{character or function. Summary function: "mean", "sum", "min",
"max", "sd", or "median"; or a user function.}

\item{na.rm}{logical. Whether to remove NAs when computing summaries.}
}
\value{
A data.frame of extracted values. When \code{d} has multiple values,
rows are stacked by scale with a \code{scale_m} column indicating the radius.
}
\description{
Extracts summary statistics from a SpatRaster at point locations,
optionally using buffered extraction with custom kernel windows.
}
\details{
\itemize{
\item If \code{d > 0}, a buffer of radius \code{d} (map units) is created around each point
and the summary is computed over raster cells intersecting the buffer.
\item If \code{d == 0}, values are taken at the point locations (no buffering).
\item If \code{y} is a polygon layer, the summary is computed over polygon areas.
}
}
\examples{
r <- terra::rast(nrows = 10, ncols = 10, xmin = 0, xmax = 100, ymin = 0, ymax = 100)
terra::values(r) <- seq_len(terra::ncell(r))

pts <- terra::vect(
  matrix(c(10, 10,
           50, 50), ncol = 2, byrow = TRUE),
  type = "points",
  crs  = terra::crs(r)
)

# Mean over a 20-unit circular neighborhood around each point
res <- fastextract(r, pts, d = 20, w = "circle", fun = "mean")
head(res)
}
