% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fjoin_functions.R
\name{fjoin_cross}
\alias{fjoin_cross}
\title{Cross join}
\usage{
fjoin_cross(
  x = NULL,
  y = NULL,
  order = "left",
  select = NULL,
  select.x = NULL,
  select.y = NULL,
  prefix.y = "R.",
  do = !(is.null(x) && is.null(y)),
  show = !do
)
}
\arguments{
\item{x, y}{\code{data.frame}-like objects (plain, \code{data.table},
tibble, \code{sf}, \code{list}, etc.) or else both omitted for a mock join
statement with no data. See Details.}

\item{order}{Whether the row order of the result should reflect \code{x} then
\code{y} (\code{"left"}) or \code{y} then \code{x} (\code{"right"}).
Default \code{"left"}.}

\item{select, select.x, select.y}{Character vectors of columns to be selected
from either input if present (\code{select}) or specifically from one or
other of them (e.g. \code{select.x}). \code{NULL} (the default) selects
all columns. Use \code{""} or \code{NA} to select no columns. Join
columns are always selected. See Details.}

\item{prefix.y}{A prefix to attach to column names in \code{y} that are the
same as a column name in \code{x}. Default \code{"R."}.}

\item{do}{Whether to execute the join. If \code{FALSE}, \code{show} is set to
\code{TRUE} and the \pkg{data.table} code for the join is printed to the
console instead. Default is \code{TRUE} unless \code{x} and \code{y} are
both omitted/\code{NULL}, in which case a mock join statement is produced.
See Details.}

\item{show}{Whether to print the \pkg{data.table} code for the join to the
console. Default is the opposite of \code{do}. If \code{x} and \code{y} are
both omitted/\code{NULL}, mock join code is displayed.}
}
\value{
A \code{data.frame}, \code{data.table}, (grouped) tibble, \code{sf},
or \code{sf}-tibble, or else \code{NULL} if \code{do} is \code{FALSE}. See
Details.
}
\description{
Cross join of \code{x} and \code{y}
}
\details{
Details are as for e.g. \code{\link{fjoin_inner}} except for remarks
about join columns and matching logic, which do not apply.
}
\examples{
# data frames
df1 <- data.table::fread(data.table = FALSE, input = "
bread    kcal
Brown     150
White     180
Baguette  250
")

df2 <- data.table::fread(data.table = FALSE, input = "
filling kcal
Cheese   200
Pâté     160
")

fjoin_cross(df1, df2)
fjoin_cross(df1, df2, order = "right")

}
\seealso{
See the package-level documentation \code{\link{fjoin}} for related
 functions.
}
