% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bci2000.R
\name{read_bci2000}
\alias{read_bci2000}
\title{Read 'BCI2000' data file}
\usage{
read_bci2000(
  file,
  extract_path = getOption("ieegio.extract_path", NULL),
  header_only = FALSE,
  cache_ok = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file path to the data file}

\item{extract_path}{location to where the extracted information is to be
stored}

\item{header_only}{whether to only load header data}

\item{cache_ok}{whether existing cache should be reused; default is
\code{TRUE}. This input can speed up reading large data files; set to
\code{FALSE} to delete cache before importing.}

\item{verbose}{whether to print processing messages; default is \code{TRUE}}
}
\value{
A cached object that is readily to be loaded to memory; see
\code{\link{SignalDataCache}} for class definition.
}
\description{
Read 'BCI2000' data file
}
\examples{


if( ieegio_sample_data("bci2k.dat", test = TRUE) ) {
  file <- ieegio_sample_data("bci2k.dat")

  x <- read_bci2000(file)
  print(x)

  channel <- x$get_channel(1)

  plot(
    channel$time,
    channel$value,
    type = "l",
    main = channel$info$Label,
    xlab = "Time",
    ylab = channel$info$Unit
  )
}


}
