% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svycox.R
\name{svycox.display}
\alias{svycox.display}
\title{svycoxph.display: table for svycoxph.object in survey package.}
\usage{
svycox.display(svycoxph.obj, decimal = 2, pcut.univariate = NULL)
}
\arguments{
\item{svycoxph.obj}{svycoxph.object}

\item{decimal}{digit, Default: 2}

\item{pcut.univariate}{pcut.univariate, Default: NULL}
}
\value{
List including table, metric, caption
}
\description{
Table for complex design cox model.
}
\details{
DETAILS
}
\examples{
library(survival)
data(pbc)
pbc$sex <- factor(pbc$sex)
pbc$stage <- factor(pbc$stage)
pbc$randomized <- with(pbc, !is.na(trt) & trt > 0)
biasmodel <- glm(randomized ~ age * edema, data = pbc, family = binomial)
pbc$randprob <- fitted(biasmodel)

if (is.null(pbc$albumin)) pbc$albumin <- pbc$alb ## pre2.9.0

dpbc <- survey::svydesign(
  id = ~1, prob = ~randprob, strata = ~edema,
  data = subset(pbc, randomized)
)

model <- survey::svycoxph(Surv(time, status > 0) ~ sex + protime + albumin + stage,
  design = dpbc
)
svycox.display(model)
}
\seealso{
\code{\link[survey]{svycoxph}}
 \code{\link[stats]{AIC}}
}
