% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsw.R
\name{global_surface_water_occurrence}
\alias{global_surface_water_occurrence}
\alias{get_global_surface_water_occurrence}
\title{Global Surface Water Occurrence}
\source{
\url{https://global-surface-water.appspot.com/}
}
\usage{
get_global_surface_water_occurrence(version = "v1_4_2021")
}
\arguments{
\item{version}{A character vector indicating the version of the GSW data set
to make available.}
}
\value{
A character of file paths.
}
\description{
The Global Surface Water dataset was developed by the European Commission's
Joint Research Centre in the framework of the Copernicus Programme. It maps
the location and temporal distribution of water surfaces at the global scale
over the past 3.8 decades and provides statistics on their extent and change.
It is provisioned as a global tiled raster resource available for all land
areas. The reported data represent aggregated observations between 1984 - 2021.
}
\details{
GSW occurrence raw data comes in raster files with integer cell values
between \code{[0, 100]}. This value gives the percentage of the time that a
given pixel was classified as water during the entire observation period. So
a 0 denotes a pixel that was never classified as water, 100 denotes a pixel
with permanent water.
}
\references{
Pekel, JF., Cottam, A., Gorelick, N. et al. High-resolution
mapping of global surface water and its long-term changes. Nature 540,
418–422 (2016). \doi{doi:10.1038/nature20584}
}
\keyword{resource}
