% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wdiag.R
\name{.Joint_MLE_Expl}
\alias{.Joint_MLE_Expl}
\title{Joint maximum likelihood estimation for exponential model}
\usage{
.Joint_MLE_Expl(x, u = NULL, k, q1, q2 = 1, param)
}
\arguments{
\item{x}{vector of data}

\item{u}{vector of thresholds. If not supplied, then \code{k}
thresholds between quantiles (\code{q1}, \code{q2}) will be used}

\item{k}{number of thresholds to consider if u not supplied}

\item{q1}{lower quantile to consider for threshold}

\item{q2}{upper quantile to consider for threshold}

\item{param}{character specifying \code{'InvRate'} or \code{'Rate'}
for either inverse rate parameter / rate parameter, respectively}
}
\value{
a list with
\itemize{
\item mle vector of MLEs above the supplied thresholds
\item cov joint asymptotic covariance matrix of these MLEs
}
}
\description{
Calculates the MLEs of the rate parameter, and joint asymptotic covariance matrix of these MLEs
over a range of thresholds as supplied by the user.
}
\author{
Jennifer L. Wadsworth
}
\keyword{internal}
