% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{tstab.hill}
\alias{tstab.hill}
\title{Threshold stability plot for Hill estimator}
\usage{
tstab.hill(xdat, kmax, method = "hill", ..., log = TRUE)
}
\arguments{
\item{xdat}{[vector] sample exceedances}

\item{kmax}{[int] maximum number of order statistics}

\item{method}{[string] name of estimator for shape parameter. Default to \code{hill}.}

\item{...}{additional arguments passed to \code{fit.shape} for certain methods.}

\item{log}{[logical] should the x-axis for the number of order statistics used for estimation be displayed on the log scale? Default to \code{TRUE}}
}
\value{
a plot of shape estimates as a function of the number of exceedances
}
\description{
Threshold stability plot for Hill estimator
}
\examples{
xdat <- rgp(n = 250, loc = 1, scale = 2, shape = 0.5)
tstab.hill(xdat)
}
