% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexMItest.R
\name{flexMItest}
\alias{flexMItest}
\title{Wrapper for gaussMItest, disMItest and mixMItest}
\usage{
flexMItest(x, y, S = NULL, suffStat)
}
\arguments{
\item{x, y, S}{(integer) position of variable X, Y and set of variables S,
respectively, in the dataset. It is tested whether X and Y are conditionally
independent given the subset S of the remaining variables.}

\item{suffStat}{a list generated using \code{\link[micd]{getSuff}} with \code{test="flexMItest"}. See below for details.}
}
\value{
A p-value.
}
\description{
A plug-in conditional independence test for \code{pcalg::\link[pcalg]{skeleton}}, \code{pcalg::\link[pcalg]{pc}} or
\code{pcalg::\link[pcalg]{fci}} when multiply imputed data sets are available. \code{flexMItest} detects whether
variables are continuous, discrete or mixed, and automatically switches between \code{\link[micd]{gaussMItest}} (continuous only),
\code{link{disMItest}} (discrete only) and \code{\link[micd]{mixMItest}} (mixed).
}
\details{
\code{suffStat} needs to be a list with four elements named \code{datlist}, \code{corlist},
\code{conpos} and \code{dispos}. \code{datlist} is the list of imputed datasets. \code{corlist}
is a list with M+1 elements, where M is the number of imputed datasets. For i=1,...,M, the
the i-th element of \code{corlist} is the correlation matrix of the continuous variables in the i-th imputed dataset;
the (M+1)-the element is the number of rows in each imputed dataset.
\code{conpos} is a vector containing the integer positions of the continuous variables in the original dataset.
\code{dispos} is a vector containing the integer positions of the discrete variables in the original dataset.
}
\examples{
## load data (numeric and factor variables)
dat <- toenail2[1:400, ]

## delete some observations
set.seed(123)
dat[sample(400, 20), 2] <- NA
dat[sample(400, 30), 4] <- NA

## impute missing values using random forests
if (requireNamespace("ranger", quietly = TRUE)) {
imp <- suppressWarnings(mice(dat, method = "rf", m = 2, printFlag = FALSE))
} else {
imp <- suppressWarnings(mice(dat, m = 2, printFlag = FALSE))
}

## obtain correct input 'suffStat' for 'flexMItest'
suff <- getSuff(imp, test="flexMItest")

## analyse data
# continuous variables only
flexMItest(4,5,NULL, suffStat = suff)
implist <- complete(imp, action="all")
gaussSuff <- c(lapply(implist, function(i){cor(i[ ,c(4,5)])}), n = 400)
gaussMItest(1,2,NULL, suffStat = gaussSuff)
flexCItwd(4, 5, NULL, dat)

# discrete variables only
flexMItest(2,3,NULL, suffStat = suff)
disMItest(2,3,NULL, suffStat = complete(imp, action="all"))
flexCItwd(2,3,NULL, dat)

# mixed variables
flexMItest(2,3,4, suffStat = suff)
mixMItest(2,3,4, suffStat = complete(imp, action="all"))
flexCItwd(2,3,4, dat)

}
\seealso{
\code{\link[micd]{gaussMItest}}, \code{\link[micd]{disMItest}} and \code{\link[micd]{mixMItest}}
}
