# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic functionality
test_that("export_list basic functionality works", {
  # Create sample data
  dt1 <- data.table(x = 1:3, y = letters[1:3])
  dt2 <- data.table(a = 4:6, b = letters[4:6])
  test_list <- list(data1 = dt1, data2 = dt2)
  
  # Create temporary directory for testing
  temp_dir <- file.path(tempdir(), "export_list_test")
  
  # Test basic export
  file_count <- export_list(test_list, export_path = temp_dir)
  
  # Check return value
  expect_equal(file_count, 2)
  
  # Check if files were created
  expect_true(file.exists(file.path(temp_dir, "data1.txt")))
  expect_true(file.exists(file.path(temp_dir, "data2.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test file type handling
test_that("export_list handles different file types", {
  dt <- data.table(x = 1:3, y = letters[1:3])
  test_list <- list(data = dt)
  
  temp_dir <- file.path(tempdir(), "export_list_types")
  
  # Test txt export
  export_list(test_list, export_path = temp_dir, file_type = "txt")
  expect_true(file.exists(file.path(temp_dir, "data.txt")))
  
  # Test csv export
  export_list(test_list, export_path = temp_dir, file_type = "csv")
  expect_true(file.exists(file.path(temp_dir, "data.csv")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test nested directory structure
test_that("export_list handles nested directory paths", {
  dt <- data.table(x = 1:3)
  test_list <- list("dir1/dir2/data" = dt)
  
  temp_dir <- file.path(tempdir(), "export_list_nested")
  
  file_count <- export_list(test_list, export_path = temp_dir)
  
  expect_equal(file_count, 1)
  expect_true(dir.exists(file.path(temp_dir, "dir1", "dir2")))
  expect_true(file.exists(file.path(temp_dir, "dir1", "dir2", "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test unnamed list elements
test_that("export_list handles unnamed list elements", {
  dt1 <- data.table(x = 1:3)
  dt2 <- data.table(y = 4:6)
  test_list <- list(dt1, dt2)
  
  temp_dir <- file.path(tempdir(), "export_list_unnamed")
  
  file_count <- export_list(test_list, export_path = temp_dir)
  
  expect_equal(file_count, 2)
  expect_true(file.exists(file.path(temp_dir, "split_1.txt")))
  expect_true(file.exists(file.path(temp_dir, "split_2.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test error handling
test_that("export_list handles errors appropriately", {
  # Test invalid input type
  expect_error(
    export_list("not_a_list"),
    "split_dt must be a list of data.tables/data.frames"
  )
  
  # Test invalid file type
  dt <- data.table(x = 1:3)
  test_list <- list(data = dt)
  expect_error(
    export_list(test_list, file_type = "invalid"),
    "should be one of"
  )
})

# Test data frame conversion
test_that("export_list handles data.frame conversion", {
  df <- data.frame(x = 1:3, y = letters[1:3])
  test_list <- list(data = df)
  
  temp_dir <- file.path(tempdir(), "export_list_df")
  
  file_count <- export_list(test_list, export_path = temp_dir)
  
  expect_equal(file_count, 1)
  expect_true(file.exists(file.path(temp_dir, "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test empty list handling
test_that("export_list handles empty list", {
  test_list <- list()
  
  temp_dir <- file.path(tempdir(), "export_list_empty")
  
  file_count <- export_list(test_list, export_path = temp_dir)
  
  expect_equal(file_count, 0)
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test mixed content in list
test_that("export_list handles mixed content types", {
  dt <- data.table(x = 1:3)
  df <- data.frame(y = 4:6)
  test_list <- list(dt_data = dt, df_data = df)
  
  temp_dir <- file.path(tempdir(), "export_list_mixed")
  
  file_count <- export_list(test_list, export_path = temp_dir)
  
  expect_equal(file_count, 2)
  expect_true(file.exists(file.path(temp_dir, "dt_data.txt")))
  expect_true(file.exists(file.path(temp_dir, "df_data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

