% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solver.R
\name{qp_solver_GA}
\alias{qp_solver_GA}
\title{Solve Quadratic Programming Problem using GA}
\usage{
qp_solver_GA(
  n,
  A,
  b,
  c,
  x_max = 1,
  print_message = FALSE,
  maxiter = 1000,
  popSize = 50,
  pmutation = 0.2,
  elitism = 5,
  monitor = FALSE,
  seed = 123,
  ...
)
}
\arguments{
\item{n}{An integer representing the number of decision variables.}

\item{A}{A matrix representing the quadratic coefficients.}

\item{b}{A numeric vector representing the linear coefficients.}

\item{c}{A numeric scalar representing the constant term in the objective function.}

\item{x_max}{An integer representing the upper bound for the decision variables. Default is 1.}

\item{print_message}{A logical value indicating whether to print optimization details. Default is FALSE.}

\item{maxiter}{An integer specifying the maximum number of iterations. Default is 1000.}

\item{popSize}{An integer specifying the population size for the GA. Default is 50.}

\item{pmutation}{A numeric value for mutation probability. Default is 0.2.}

\item{elitism}{An integer specifying the number of elite individuals to carry over to the next generation. Default is 5.}

\item{monitor}{A logical value indicating whether to display progress. Default is FALSE.}

\item{seed}{A numeric value used for the random number generator. Default is 123.}

\item{...}{Additional control parameters for \code{ga}.}
}
\value{
A list containing:
\item{f_cd}{The optimal objective function value.}
\item{x_value}{The optimal values of the decision variables.}
}
\description{
This function solves a quadratic programming problem using the Genetic Algorithm (GA) from the \code{GA} package.
}
\seealso{
\code{\link{qp_solver}}, \code{\link{qp_solver_DEoptim}}, \code{\link{qp_solver_nloptr}}
}
