% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize.R
\name{mc_load}
\alias{mc_load}
\title{Load myClim object}
\usage{
mc_load(file)
}
\arguments{
\item{file}{path to input .rds file. If value is vector of files, myClim objects
are merged with function \link{mc_prep_merge}. If path is directory, then all .rds files are used.}
}
\value{
loaded myClim object
}
\description{
This function loads the myClim .rds data object saved with \link{mc_save}.
The \code{mc_save} and \code{mc_load} functions secure that the myClim object is correctly
loaded across myClim versions.
}
\examples{
tmp_dir <- tempdir()
tmp_file <- tempfile(tmpdir = tmp_dir)
mc_save(mc_data_example_agg, tmp_file)
data <- mc_load(tmp_file)
file.remove(tmp_file)
}
