% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_neuralGAM_data.R
\name{sim_neuralGAM_data}
\alias{sim_neuralGAM_data}
\title{Simulate Example Data for NeuralGAM}
\usage{
sim_neuralGAM_data(n = 2000, seed = 42, test_prop = 0.3)
}
\arguments{
\item{n}{Integer. Number of observations to generate. Default \code{2000}.}

\item{seed}{Integer. Random seed for reproducibility. Default \code{42}.}

\item{test_prop}{Numeric in \eqn{[0,1]}. Proportion of data to reserve for the test set. Default \code{0.3}.}
}
\value{
A list with two elements:
\itemize{
\item \code{train}: data.frame with training data.
\item \code{test}: data.frame with test data.
}
}
\description{
Generate a synthetic dataset for demonstrating and testing
\code{\link{neuralGAM}}. The response is constructed from three covariates:
a quadratic effect, a linear effect, and a sinusoidal effect, plus Gaussian noise.
}
\details{
The data generating process is:
\deqn{y = 2 + x1^2 + 2 x2 + \sin(x3) + \varepsilon,}
where \eqn{\varepsilon \sim N(0, 0.25^2)}.

Covariates \eqn{x1}, \eqn{x2}, \eqn{x3} are drawn independently from
\eqn{U(-2.5, 2.5)}.
}
\examples{
\dontrun{
set.seed(123)
dat <- sim_neuralGAM_data(n = 500, test_prop = 0.2)

train <- dat$train
test  <- dat$test

}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
