% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pooled_data.R
\name{pooled_control}
\alias{pooled_control}
\title{Control settings for pooled data analysis}
\usage{
pooled_control(
  nbins = 10,
  bin_method = c("quantile", "jenks", "kmeans", "pretty", "sd", "equal", "density"),
  tad_rounding = TRUE
)
}
\arguments{
\item{nbins}{Integer or the character string auto. Number of time bins used
to group observations. Default is 10.}

\item{bin_method}{Character string specifying the binning method. Must be one
of "quantile", "jenks", "kmeans", "pretty", "sd", "equal", or "density".}

\item{tad_rounding}{Logical value indicating whether tad and the most common
dosing interval should be rounded to the nearest whole unit before
comparison. Default is TRUE, allowing small deviations (for example, a tad
of 24.3 is treated as within a 24-unit interval).}
}
\value{
A named list containing control parameters for pooled pharmacokinetic
analysis.
}
\description{
Defines control parameters for time binning and preprocessing in pooled
data analysis. These parameters are typically passed to 'get_pooled_data'.
}
\examples{
pooled_control()

}
\seealso{
\link{get_pooled_data}
}
