#' Plot [mds_test()] results
#'
#' `r lifecycle::badge('experimental')`  Plot output from [mds_test()].
#'
#' @importFrom ggplot2 ggplot geom_boxplot geom_point labs
#' @importFrom dplyr filter
#'
#' @param mds_test Object of class `mds_test_results` (generated by [mds_test()]).
#'
#' @return `ggplot` object.
#' @export
#'
#' @examples
#' mds_result <- mds_test(
#'     sim_matrix,
#'     n_boots = 10,
#'     n_perms = 10,
#'     test_dimensions = 3,
#'     mds_type = 'interval'
#'  )
#'  plot_mds_test(mds_result)
plot_mds_test <- function(mds_test) {
  mds_test$stress_reduction |>
    filter(
      .data$source != "original"
    ) |>
    ggplot(
      aes(
        x = factor(.data$dims),
        y = diff,
        colour = factor(.data$source, labels = c("Bootstrapped", "Null"))
      )
    ) +
    geom_boxplot() +
    geom_point(
      data = mds_test$stress_reduction |>
       filter(.data$source == "original"),
      colour = "black",
      shape = 4,
      size = 5,
      stroke = 2
    ) +
    labs(
      colour = "Source",
      x = "Dimensions",
      y = "Stress reduction"
    )
}
