% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.R
\name{opal.project_restore}
\alias{opal.project_restore}
\title{Restore a project}
\usage{
opal.project_restore(
  opal,
  project,
  archive,
  key = NULL,
  override = TRUE,
  wait = TRUE
)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{archive}{Archive directory or zip file path in the Opal file system.}

\item{key}{Archive zip file password (if applies).}

\item{override}{Overwrite existing items (table, view, resource, report). Project files override is not checked. Default is TRUE.}

\item{wait}{Wait for restore task completion. Default is TRUE.}
}
\value{
The project command ID if wait parameter is FALSE. See \link{opal.project_command} to retrieve asynchronous command state.
}
\description{
Restore the data of a project from a backup archive file to be found on the Opal file system. 
The destination project must exist and can have a name different from the original one 
(beware that this could break views). Default behavior is to stop when an item to restore 
already exist (override can be forced).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# create the project to restore, with the default database (to store tables)
opal.project_create(o, 'GREENSPACE2', database = TRUE)
# upload backup zip and launch restore task
opal.file_upload(o, 'GREENSPACE.zip', '/home/administrator')
opal.project_restore(o, 'GREENSPACE2', '/home/administrator/GREENSPACE.zip')
opal.logout(o)
}
}
