% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_update_table}
\alias{wb_update_table}
\title{Update a data table position in a worksheet}
\usage{
wb_update_table(wb, sheet = current_sheet(), dims = "A1", tabname)
}
\arguments{
\item{wb}{A workbook}

\item{sheet}{A worksheet}

\item{dims}{Cell range used for new data table.}

\item{tabname}{A table name}
}
\description{
Update the position of a data table, possibly written using \code{\link[=wb_add_data_table]{wb_add_data_table()}}
}
\details{
Be aware that this function does not alter any filter.
Excluding or adding rows does not make rows appear nor will it hide them.
}
\examples{
wb <- wb_workbook()$add_worksheet()$add_data_table(x = mtcars)
wb$update_table(tabname = "Table1", dims = "A1:J4")
}
