test_that("Cliff_independent_basic", {
  x <- c(6, 7, 9, 10)
  y <- c(1, 3, 4, 7, 8)
  result <- Cliff_independent(x, y)
  expect_true(abs(0.65 - result$d_bar) <= 0.005)
  expect_true(abs(0.269 - result$sigma_d_bar) <= 0.0005)
  expect_true(abs(2.41 - result$z_d_bar) <= 0.005)
}
)


test_that("Cliff_independent_from_matrix", {
  result1 <- Cliff_independent_from_matrix(hypothalamus_1)
  expect_true(abs(-0.266 - result1$d_bar) <= 0.0005)
  expect_true(abs(0.194 - result1$sigma_d_bar) <= 0.0005,
              info=paste(0.194, result1$sigma_d_bar))
  expect_true(abs(-1.37 - result1$z_d_bar) <= 0.005,
              info=paste(-1.37, result1$z_d_bar))

  result2 <- Cliff_independent_from_matrix(hypothalamus_2)
  expect_true(abs(-0.595 - result2$d_bar) <= 0.0005,
              info=paste(-0.595, result2$bar))
  expect_true(abs(0.163 - result2$sigma_d_bar) <= 0.0005,
              info=paste(0.163, result2$sigma_d_bar))
  expect_true(abs(-3.65 - result2$z_d_bar) <= 0.005,
              info=paste(-3.65, result2$z_d_bar))
}
)


test_that("Cliff_independent_weighted", {
  x1 <- 1:4
  x2 <- 1:4
  w1 <- c(15, 20, 9, 12)
  w2 <- c(10, 25, 12, 9)
  var1 <- expand(x1, w1)
  var2 <- expand(x2, w2)
  result1 <- Cliff_independent(var1, var2)
  result2 <- Cliff_independent_weighted(x1, w1, x2, w2)

  expect_true(abs(result1$d_bar - result2$d_bar) <= 1.0e-10,
              info=paste("d_bar", result1$d_bar, result2$d_bar))
  expect_true(abs(result1$sigma_d_bar - result2$sigma_d_bar) <= 1.0e-10,
              info=paste("sigma_d_bar", result1$sigma_d_bar, result2$sigma_d_bar))
  expect_true(abs(result1$z_d_bar - result2$z_d_bar) <= 1.0e-10,
              info=paste("z_d_bar", result1$z_d_bar, result2$z_d_bar))
}
)


test_that("Cliff_independent_from_table", {
  testthat::skip_on_cran()
  print("running vision data - this may take a couple of minutes for unweighted comparison")

  n <- vision_data
  result1 <- Cliff_independent_from_table(n)

  N <- sum(n)
  x <- vector("double", N)
  y <- vector("double", N)
  index <- 1
  for (i in 1:nrow(n)) {
    for (j in 1:ncol(n)) {
      for (k in 1:n[i, j]) {
        x[index] <- i
        y[index] <- j
        index <- index + 1
      }
    }
  }
  result2 <- Cliff_independent(x, y)

  expect_true(abs(result1$d_bar - result2$d_bar) <= 1.0e-8)
  expect_true(abs(result1$sigma_d_bar - result2$sigma_d_bar) <= 1.0e-8)
  expect_true(abs(result1$z_d_bar - result2$z_d_bar) <= 1.0e-8)
}
)
