% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{summary.pc_effect}
\alias{summary.pc_effect}
\title{Summarize Pattern Causality Effect}
\usage{
\method{summary}{pc_effect}(object, ...)
}
\arguments{
\item{object}{A \code{pc_effect} object.}

\item{...}{Additional arguments passed to the \code{summary} function.}
}
\value{
Invisibly returns the input object.
}
\description{
Provides a summary of the pattern causality effect analysis results.
This function displays the summary statistics for the effects,
including the number of components and the strongest effects.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1,
  metric = "euclidean", h = 1, weighted = TRUE,
  verbose = FALSE)
effects <- pcEffect(pc_matrix_obj)
summary(effects)
}
}
