% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestry.R
\name{rename_variant_identifiers}
\alias{rename_variant_identifiers}
\title{Renaming variants}
\usage{
rename_variant_identifiers(
  indir,
  name,
  qcdir = indir,
  verbose = FALSE,
  path2plink2 = NULL,
  format = "@:#[hg38]",
  showPlinkOutput = TRUE
)
}
\arguments{
\item{indir}{[character] /path/to/directory containing the basic PLINK 2.0 data
file name.pgen, name.pvar, name.psam}

\item{name}{[character] Prefix of PLINK 2.0 files, i.e. name.pgen, name.pvar, 
name.psam}

\item{qcdir}{[character] /path/to/directory where name.sscore as returned by 
plink2 --score will be saved to. User needs writing permission to qcdir. Per 
default is qcdir=indir.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}

\item{path2plink2}{[character] Absolute path to PLINK executable
(\url{https://www.cog-genomics.org/plink/2.0/}) i.e.
plink 2 should be accessible as path2plink -h. The full name of the executable
should be specified: for windows OS, this means path/plink.exe, for unix
platforms this is path/plink. If not provided, assumed that PATH set-up works
and PLINK will be found by \code{\link[sys]{exec}}('plink').}

\item{format}{[character] This gives the template to rewrite the variant identifier.
A '@' represents the chromosome code, and a '#' represents the base-pair position.}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}
}
\value{
Files with a .renamed in them that have the renamed variants
}
\description{
Changes the format of the variant identifier. The default is in the format of
chr1:12345[hg38].
}
\examples{
indir <- system.file("extdata", package="plinkQC")
qcdir <- tempdir()
name <- "data.hg38"
path2plink <- '/path/to/plink'
\dontrun{
# the following code is not run on package build, as the path2plink on the
# user system is not known.
rename_variant_identifiers(indir=indir, qcdir=qcdir, name=name, path2plink2 = path2plink2)
}
}
