% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stratifiedItersplits}
\alias{stratifiedItersplits}
\title{stratifiedItersplits}
\usage{
stratifiedItersplits(splits, groupsizes)
}
\arguments{
\item{splits}{Number of iterations.}

\item{groupsizes}{An integer vector of how many RTs per group need to be stratified.}
}
\value{
A matrix with zeroes and ones. Each column is a random split.
}
\description{
Generate stratified splits for a single participant
}
\details{
This equally splits what can be equally split within groups.
Then it randomly splits all the leftovers to ensure near-equal split sizes.
This function is moreso used internally, 
but you can use it if you know what you are doing.
}
\examples{

# We will create splits stratified by stimulus for a single participant
data(foodAAT)
currdata<-foodAAT[foodAAT$subjectid==3,]
currdata$stratfactor<-interaction(currdata$is_pull,currdata$is_target,currdata$stimid)
currdata<-currdata[order(currdata$stratfactor),]
groupsizes<-rle(as.character(currdata$stratfactor))$lengths

mysplits<-stratifiedItersplits(splits=1000,groupsizes=groupsizes)

# Now the data can be split with the values from any column.
half1<-currdata[mysplits[,1]==1,]
half2<-currdata[mysplits[,1]==0,]

# Or the split objects can be used as masks for the aggregation functions in this package
meansByMask(x=currdata$RT,mask=mysplits==1)
 
}
