% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class114-recording_blocks_timefreqcoefs.R
\name{RAVESubjectRecordingBlockTimeFreqCoefRepository}
\alias{RAVESubjectRecordingBlockTimeFreqCoefRepository}
\title{'RAVE' class for loading time-frequency coefficients}
\description{
Loads time-frequency coefficients (complex numbers)
}
\seealso{
\code{\link{prepare_subject_time_frequency_coefficients_with_blocks}}
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectRecordingBlockRepository]{ravecore::RAVESubjectRecordingBlockRepository}} -> \code{\link[ravecore:RAVESubjectRecordingBlockTimeFreqBaseRepository]{ravecore::RAVESubjectRecordingBlockTimeFreqBaseRepository}} -> \code{RAVESubjectRecordingBlockTimeFreqCoefRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{coefficients}}{data container, alias of \code{get_container}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@marshal}{\code{RAVESubjectRecordingBlockTimeFreqCoefRepository$@marshal()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@unmarshal}{\code{RAVESubjectRecordingBlockTimeFreqCoefRepository$@unmarshal()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqCoefRepository-new}{\code{RAVESubjectRecordingBlockTimeFreqCoefRepository$new()}}
\item \href{#method-RAVESubjectRecordingBlockTimeFreqCoefRepository-clone}{\code{RAVESubjectRecordingBlockTimeFreqCoefRepository$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-export_matlab'><code>ravecore::RAVESubjectRecordingBlockRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectRecordingBlockRepository.html#method-RAVESubjectRecordingBlockRepository-get_container'><code>ravecore::RAVESubjectRecordingBlockRepository$get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRecordingBlockTimeFreqBaseRepository" data-id="mount_data"><a href='../../ravecore/html/RAVESubjectRecordingBlockTimeFreqBaseRepository.html#method-RAVESubjectRecordingBlockTimeFreqBaseRepository-mount_data'><code>ravecore::RAVESubjectRecordingBlockTimeFreqBaseRepository$mount_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqCoefRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqCoefRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqCoefRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqCoefRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqCoefRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqCoefRepository$new(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  blocks = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{reference_name}}{name of the reference table}

\item{\code{blocks}}{name of the recording blocks to load}

\item{\code{...}}{passed to \code{\link{RAVESubjectBaseRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay (lazy) the evaluation \code{mount_data}}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectRecordingBlockTimeFreqCoefRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectRecordingBlockTimeFreqCoefRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectRecordingBlockTimeFreqCoefRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
