% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spec.R
\name{create_plot}
\alias{create_plot}
\title{Create plot content}
\usage{
create_plot(x, height, width, borders = "none")
}
\arguments{
\item{x}{The plot to create.  Specifically, this parameter should be 
set to an object returned from a call to \code{\link[ggplot2]{ggplot}}
or \code{\link[survminer]{ggsurvplot}}.  This parameter also accepts 
a path to a JPEG file.  If a path is specified, the image will be appended
to the report at the point the content object is added. For RTF and DOCX files, 
the function additionally accepts a path to an EMF file.}

\item{height}{The height of the plot in the specified units of measure.}

\item{width}{The width of the plot in the specified units of measure.}

\item{borders}{Whether and where to place a border. Valid values are 'top',
'bottom', 'left', 'right', 'all', 'none', and 'outside'.  
Default is 'none'.  The 'left', 'right', and 'outside' 
border specifications do not apply to TXT reports.}
}
\value{
The plot specification.
}
\description{
Function to create a plot specification that can be 
added as content to a report. The \code{create_plot} function can 
be used to include charts, graphs, and figures on a statistical report.  
The function supports plot objects returned by 
\code{\link[ggplot2]{ggplot}} or \code{\link[survminer]{ggsurvplot}}.  
It does not support the Base R 
\code{plot} function.
}
\details{
To add a plot to a report, use the \code{create_plot} function.  The 
function allows you to set a width and height for the plot.  The
function will preserve any other geometries you apply to the plot.  See
the \code{\link{add_content}} function to control page breaking and 
blanks spaces above or below the plot.    

A plot specification accepts a \code{\link{page_by}} function.  If a page by
is applied to the plot, the plot data will be subset by the page by 
variable, and re-run for each subset.

The plot specification also accepts titles and footnotes.  See the 
\code{\link{titles}} and \code{\link{footnotes}} functions for further 
details.

The function 
also accepts a path to an image file stored on the file system instead of a 
plot object.  This
functionality was added to allow the user to create figures from other
plotting packages.  If you pass an image path, the image will be inserted
into the report at the location specified. The system supports JPEG images 
for all output types that support graphics. EMF images are also supported for
DOCX and RTF outputs. Note that EMF format may not render properly in 
all operating environments, and JPEG is the preferred image type.
}
\examples{
library(reporter)
library(ggplot2)
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.rtf")

# Create ggplot
p <- ggplot(mtcars, aes(x=cyl, y=mpg)) + geom_point()

# Create plot object
plt <- create_plot(p, height = 4, width = 8)

rpt <- create_report(tmp, font = "Arial", output_type = "RTF") \%>\%
  page_header("Client", "Study: XYZ") \%>\% 
  titles("Figure 1.0", "MTCARS Miles per Cylinder Plot") \%>\%
  set_margins(top = 1, bottom = 1) \%>\%
  add_content(plt) \%>\%
  footnotes("* Motor Trend, 1974") \%>\% 
  page_footer("Time", "Confidential", "Page [pg] of [tpg]")

# Write out report
write_report(rpt)

# Uncomment to view RTF file
# shell.exec(tmp)
}
\seealso{
\code{\link{titles}} to add a title block to the plot,  
\code{\link{footnotes}} to add footnotes, and \code{\link{add_content}} 
to add the plot object to a report.

Other plot: 
\code{\link{print.plot_spec}()}
}
\concept{plot}
