% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_traceability_matrix.R
\name{create_traceability_matrix}
\alias{create_traceability_matrix}
\title{Create a Traceability Matrix}
\usage{
create_traceability_matrix(
  pkg_name,
  pkg_source_path,
  func_covr = NULL,
  verbose = FALSE,
  execute_coverage = TRUE
)
}
\arguments{
\item{pkg_name}{name of package}

\item{pkg_source_path}{path to a source package}

\item{func_covr}{function coverage}

\item{verbose}{Logical (`TRUE`/`FALSE`). If `TRUE`, show any warnings/messages per function.}

\item{execute_coverage}{Logical (`TRUE`/`FALSE`). If `TRUE`, execute test coverage.}
}
\value{
a nested list with fine grained traceability matrices
}
\description{
Returns a table that links all exported functions and their aliases to their documentation (`man` files),
the R scripts containing them, and the test scripts that reference them.
}
\examples{
\dontrun{
# set CRAN repo to enable running of reverse dependencies
r = getOption("repos")
r["CRAN"] = "http://cran.us.r-project.org"
old <- options(repos = r)

dp <- system.file("test-data", "here-1.0.1.tar.gz", 
   package = "risk.assessr")

# Set up the package using the temporary file
install_list <- set_up_pkg(dp)

# Extract information from the installation list
build_vignettes <- install_list$build_vignettes
package_installed <- install_list$package_installed
pkg_source_path <- install_list$pkg_source_path
rcmdcheck_args <- install_list$rcmdcheck_args

# check if the package needs to be installed locally
package_installed <- install_package_local(pkg_source_path)

# Get package name and version
pkg_desc <- get_pkg_desc(pkg_source_path, 
                         fields = c("Package", 
                                    "Version"))
pkg_name <- pkg_desc$Package
test_pkg_data <- check_pkg_tests_and_snaps(pkg_source_path)

covr_timeout <- Inf

if (test_pkg_data$has_testthat || test_pkg_data$has_testit) {
  
  covr_list <- run_coverage(
    pkg_source_path,  
    covr_timeout
  )    
} else {
  message("No testthat or testit configuration")
  covr_list <- list(
    total_cov = 0,
    res_cov = list(
      name = pkg_name,
      coverage = list(
        filecoverage = matrix(0, nrow = 1, dimnames = list("No functions tested")),
        totalcoverage = 0
      ),
      errors = "No testthat or testit configuration",
      notes = NA
    )
  )
}
# run without test coverage   
tm_list_no_covr <- create_traceability_matrix(pkg_name, 
                                      pkg_source_path,
                                      execute_coverage = FALSE)   
                                      
# run with test coverage                                         
tm_list_covr <- create_traceability_matrix(pkg_name, 
                                      pkg_source_path,
                                      covr_list$res_cov)
                                      
# run with test coverage parameter but no test coverage list                                        
tm_list_no_covr_list <- create_traceability_matrix(pkg_name, 
                                      pkg_source_path)   
                                         
options(old)
}

}
