% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rrow}
\alias{rrow}
\title{Create an \code{rtable} row}
\usage{
rrow(
  row.name = "",
  ...,
  format = NULL,
  indent = 0,
  inset = 0L,
  round_type = valid_round_type
)
}
\arguments{
\item{row.name}{(\code{string} or \code{NULL})\cr row name. If \code{NULL}, an empty string is used as \code{row.name} of the
\code{\link[=rrow]{rrow()}}.}

\item{...}{cell values.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr the format label (string) or formatter function to apply to the
cell values passed via \code{...}. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for currently supported format labels.}

\item{indent}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{inset}{(\code{integer(1)})\cr the table inset for the row or table being constructed. See
\code{\link[formatters:table_inset]{formatters::table_inset()}} for details.}

\item{round_type}{(\code{"iec"}, \code{"iec_mod"} or \code{"sas"})\cr the type of rounding to perform.
See \code{\link[formatters:round_fmt]{formatters::round_fmt()}} for details.}
}
\value{
A row object of the context-appropriate type (label or data).
}
\description{
Create an \code{rtable} row
}
\examples{
rrow("ABC", c(1, 2), c(3, 2), format = "xx (xx.\%)")
rrow("")

}
\seealso{
Other compatibility: 
\code{\link{rheader}()},
\code{\link{rrowl}()},
\code{\link{rtable}()}
}
\concept{compatibility}
