% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_regtable.R
\name{scf_regtable}
\alias{scf_regtable}
\title{Format and Display Regression Results from Multiply-Imputed SCF Models}
\usage{
scf_regtable(
  ...,
  model.names = NULL,
  digits = 0,
  auto_digits = FALSE,
  labels = NULL,
  output = c("console", "markdown", "csv"),
  file = NULL
)
}
\arguments{
\item{...}{One or more SCF regression model objects, or a single list of such models.}

\item{model.names}{Optional character vector naming the models. Defaults to
\code{"Model 1"}, \code{"Model 2"}, etc.}

\item{digits}{Integer specifying decimal places for numeric formatting when
\code{auto_digits = FALSE}. Default is 0.}

\item{auto_digits}{Logical; if \code{TRUE}, uses adaptive decimal places:
0 digits for large numbers (>= 1000), 2 digits for moderate (>= 1),
and 3 digits for smaller values.}

\item{labels}{Optional named character vector or labeling function to replace
term names with descriptive labels.}

\item{output}{Output format: one of \code{"console"} (print to console),
\code{"markdown"} (print Markdown table for R Markdown), or \code{"csv"}
(write CSV file).}

\item{file}{File path for CSV output; required if \code{output = "csv"}.}
}
\value{
Invisibly returns a data frame with formatted regression results and fit statistics.
}
\description{
This function formats and aligns coefficient estimates, standard errors, and
significance stars from one or more SCF regression model objects
(e.g., from \code{scf_ols()}, \code{scf_logit()}, or \code{scf_glm()}).
}
\details{
It compiles a side-by-side table with terms matched across models, appends
model fit statistics (sample size N, R-squared or pseudo-R-squared, and AIC),
and outputs the results as console text, Markdown for R Markdown documents,
or a CSV file.

The function aligns all unique coefficient terms across provided models, formats
coefficients with significance stars and standard errors, appends model fit
statistics as additional rows, and renders output in the specified format.
It avoids external dependencies by using base R formatting and simple text or
Markdown output.
}
\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("regtable_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Wrangle data for example:  Perform OLS regression 
m1 <- scf_ols(scf2022, income ~ age)

# Example for real analysis: Print regression results as a console table
scf_regtable(m1, digits = 2)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
