% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{update.sdmTMB}
\alias{update.sdmTMB}
\title{Update an sdmTMB model}
\usage{
\method{update}{sdmTMB}(object, formula., ..., evaluate = TRUE)
}
\arguments{
\item{object}{An sdmTMB model object}

\item{formula.}{Optional updated formula}

\item{...}{Other arguments to update in the model call}

\item{evaluate}{If \code{TRUE} (default), the updated call is evaluated;
if \code{FALSE}, the call is returned unevaluated}
}
\value{
An updated sdmTMB model object (if \code{evaluate = TRUE}) or
an unevaluated call (if \code{evaluate = FALSE})
}
\description{
This method updates an sdmTMB model with new arguments, automatically
handling the mesh object to avoid environment issues when loading
models from saved files.
}
\examples{
mesh <- make_mesh(pcod_2011, c("X", "Y"), cutoff = 20)
fit <- sdmTMB(density ~ 1, data = pcod_2011, mesh = mesh,
  family = tweedie(link = "log"))
fit2 <- update(fit, family = delta_gamma())
}
