% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{addCompRisk}
\alias{addCompRisk}
\title{Generating single competing risk survival variable}
\usage{
addCompRisk(
  dtName,
  events,
  timeName,
  censorName = NULL,
  eventName = "event",
  typeName = "type",
  keepEvents = FALSE,
  idName = "id"
)
}
\arguments{
\item{dtName}{Name of complete data set to be updated}

\item{events}{Vector of column names that include
time-to-event outcome measures}

\item{timeName}{A string to indicate the name of the combined competing risk
time-to-event outcome that reflects the minimum observed value of all 
time-to-event outcomes.}

\item{censorName}{The name of a time-to-event variable that is the censoring
variable. Must be one of the "events" names. Defaults to NULL.}

\item{eventName}{The name of the new numeric/integer column representing the
competing event outcomes. If censorName is specified, the integer value for
that event will be 0. Defaults to "event", but will be ignored 
if timeName is NULL.}

\item{typeName}{The name of the new character column that will indicate the
event type. The type will be the unique variable names in survDefs. Defaults
to "type", but will be ignored if timeName is NULL.}

\item{keepEvents}{Indicator to retain original "events" columns. Defaults
to FALSE.}

\item{idName}{Name of id field in existing data set.}
}
\value{
An updated data table
}
\description{
Generating single competing risk survival variable
}
\examples{
d1 <- defData(varname = "x1", formula = .5, dist = "binary")
d1 <- defData(d1, "x2", .5, dist = "binary")

dS <- defSurv(varname = "reinc", formula = "-10 - 0.6*x1 + 0.4*x2", shape = 0.3)
dS <- defSurv(dS, "death", "-6.5 + 0.3*x1 - 0.5*x2", shape = 0.5)
dS <- defSurv(dS, "censor", "-7", shape = 0.55)

dd <- genData(10, d1)
dd <- genSurv(dd, dS)

addCompRisk(dd, c("reinc","death", "censor"), timeName = "time",
   censorName = "censor", keepEvents = FALSE)

}
\concept{utility}
