% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avns.R
\name{gen_bi}
\alias{gen_bi}
\title{Generate Bias-Instability Process}
\usage{
gen_bi(sigma2, n_total, n_block, title = NULL, seed = 135, ...)
}
\arguments{
\item{sigma2}{A \code{double} value for the variance parameter \eqn{\sigma ^2}{sigma^2}.}

\item{n_total}{An \code{integer} indicating the length of the simulated bias-instability process.}

\item{n_block}{An \code{integer} indicating the length of each block of the bias-instability process.}

\item{title}{A \code{string} defining the name of the time series data.}

\item{seed}{An \code{integer} defined for simulation replication purposes.}

\item{...}{Additional parameters.}
}
\value{
A \code{vector} containing the bias-instability process.
}
\description{
This function allows to generate a non-stationary bias-instability process.
}
\note{
This function generates a non-stationary bias-instability process
whose theoretical maximum overlapping allan variance (MOAV) is close to the theoretical
MOAV of the best approximation of this process through a stationary AR(1) process over some scales. However, this approximation 
is not good enough when considering the logarithmic representation of the allan variance.
Therefore, the exact form of the allan variance of this non-stationary process allows us 
to better interpret the signals characterized by bias-instability, as shown in "A Study 
of the Allan Variance for Constant-Mean Non-Stationary Processes" by Xu et al. (IEEE Signal 
Processing Letters, 2017), preprint available: \url{https://arxiv.org/abs/1702.07795}.
}
\examples{
Xt = gen_bi(sigma2 = 1, n_total = 1000, n_block = 10)
plot(Xt)

Yt = gen_bi(sigma2 = 0.8, n_total = 800, n_block = 20,
title = "non-stationary bias-instability process")
plot(Yt)
}
\author{
Yuming Zhang
}
