% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STR.R
\name{estimateSTR}
\alias{estimateSTR}
\title{Estimate Soil Temperature Regime}
\usage{
estimateSTR(
  mast,
  mean.summer,
  mean.winter,
  O.hz = NA,
  saturated = NA,
  permafrost = FALSE
)
}
\arguments{
\item{mast}{vector of mean annual soil temperature (deg C)}

\item{mean.summer}{vector of mean summer soil temperature (deg C)}

\item{mean.winter}{vector of mean winter soil temperature (deg C)}

\item{O.hz}{logical vector of O horizon presence / absence}

\item{saturated}{logical vector of seasonal saturation}

\item{permafrost}{logical vector of permafrost presence / absence}
}
\value{
Vector of soil temperature regimes.
}
\description{
Estimate soil temperature regime (STR) based on mean annual soil temperature
(MAST), mean summer temperature (MSST), mean winter soil temperature (MWST),
presence of O horizons, saturated conditions, and presence of permafrost.
Several assumptions are made when O horizon or saturation are undefined.
}
\details{
\href{http://ncss-tech.github.io/AQP/soilDB/STR-eval.html}{Soil Temperature Regime Evaluation Tutorial}
}
\examples{

# simple example
estimateSTR(mast=17, mean.summer = 22, mean.winter = 12)


}
\references{
Soil Survey Staff. 2015. Illustrated guide to soil taxonomy.
U.S. Department of Agriculture, Natural Resources Conservation Service,
National Soil Survey Center, Lincoln, Nebraska.
}
\seealso{
\code{\link{STRplot}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
