% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc.R
\name{pc}
\alias{pc}
\alias{pc,sf-method}
\alias{pc,SpatRaster-method}
\title{optimal parameter search for pattern causality}
\usage{
\S4method{pc}{sf}(
  data,
  column,
  target,
  E = 2:10,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  zero.tolerance = max(k),
  relative = TRUE,
  weighted = TRUE,
  maximize = "positive",
  threads = detectThreads(),
  detrend = FALSE,
  nb = NULL
)

\S4method{pc}{SpatRaster}(
  data,
  column,
  target,
  E = 2:10,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  zero.tolerance = max(k),
  relative = TRUE,
  weighted = TRUE,
  maximize = "positive",
  threads = detectThreads(),
  detrend = FALSE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors used.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{lib}{(optional) libraries indices (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{pred}{(optional) predictions indices (input requirement same as \code{lib}).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{zero.tolerance}{(optional) maximum number of zeros tolerated in signature space.}

\item{relative}{(optional) whether to calculate relative changes in embeddings.}

\item{weighted}{(optional) whether to weight causal strength.}

\item{maximize}{(optional) causality metric to maximize: one of "positive", "negative", or "dark".}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
\item{\code{maximize}}{maximized causality metric}
}
}
\description{
optimal parameter search for pattern causality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
pc(columbus,"hoval","crime",E = 5:10,maximize = "negative")
}
}
\references{
Stavroglou, S.K., Pantelous, A.A., Stanley, H.E., Zuev, K.M., 2020. Unveiling causal interactions in complex systems. Proceedings of the National Academy of Sciences 117, 7599–7605.
}
