% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{timeout}
\alias{timeout}
\title{Run expressions with a timeout limit}
\usage{
timeout(
  expr,
  time_out = 1,
  on_timeout = {
     stop("Timout reached", call. = FALSE)
 },
  on_final = {
 },
  env = parent.frame()
)
}
\arguments{
\item{expr}{expressions, wrap them inside `{}`}

\item{time_out}{numeric, timeout time, in seconds}

\item{on_timeout}{expressions, callback expressions to run it the time out limit
is reached but expression is still running. Default is to return an error.}

\item{on_final}{expressions, callback expressions to run in the end regardless
the state and results}

\item{env}{environment, which environment to evaluate the expressions. Default is
the same environment as where the `timeout` function is called.}
}
\value{
default return, all depends on what return the `expr` will have
}
\description{
Add a time limit for R expressions
}
\details{
Expressions will be evaluated in the parent environment by default, for example
if this function is called at global level, all returns, assignments inside
`expr` will directly go to global environment as well.
}
\examples{
# The `try` command in following examples are here to make sure the
# R CMD check will pass on package check. In a real case, you do not
# need it.

# default
try(timeout({Sys.sleep(0.1)}, time_out = 0.01))
# timeout is evaluating expressions the same level as you call it
timeout({abc <- 123})
# so you should get `abc` even outside the function call
abc
# custom timeout callback
timeout({Sys.sleep(0.1)}, time_out = 0.01, on_timeout = {print("It takes too long")})
# final call back
try(timeout({Sys.sleep(0.1)}, time_out = 0.01, on_final = {print("some final words")})) # on error
timeout({123}, on_final = {print("runs even success")})  # on success
# assign to value
my_val <- timeout({10 + 1})
my_val
}
