% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmetagenes.R
\name{plotmetagenes}
\alias{plotmetagenes}
\title{Plot Metagenes for Gene Groups}
\usage{
plotmetagenes(unigroupdf, dfmeandiff, expdf, plottype = "attenuation",
daucname = "dAUC_Diff_meanFx_HS_ctrl", auc_ctrlname = "AUC_ctrl",
auc_stressname = "AUC_HS", plot = FALSE, formatname = "pdf",
outfold = tempdir(), verbose = TRUE)
}
\arguments{
\item{unigroupdf}{A data frame containing gene-level information, including
group classifications and dAUC data for different conditions (see
universegroup).}

\item{dfmeandiff}{A data frame containing mean transcription values and
coordinates for each transcript (see meandifference).}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{plottype}{A string specifying the group of genes to plot. Options are
\code{"attenuation"}, \code{"outgroup"}, \code{"universe"}, or \code{"all"}.
Default is \code{"attenuation"}.}

\item{daucname}{A string specifying the column name for the delta AUC value
(difference between conditions). Default is
\code{"dAUC_Diff_meanFx_HS_ctrl"}.}

\item{auc_ctrlname}{A string specifying the column name for the control
condition AUC values. Default is \code{"AUC_ctrl"}.}

\item{auc_stressname}{A string specifying the column name for the stress
condition AUC values. Default is \code{"AUC_HS"}.}

\item{plot}{A logical flag indicating whether to display the plot
interactively (\code{TRUE}) or save it to a file (\code{FALSE}).
Default is \code{FALSE}.}

\item{formatname}{A string specifying the format of the saved plot file.
Default is \code{"pdf"}.}

\item{outfold}{A string specifying the output folder where the plot will be
saved if \code{plot = FALSE}. Default is the current directory.}

\item{verbose}{A logical flag indicating whether to display detailed
messages about the function's progress. Default is \code{TRUE}.}
}
\value{
A metagene plot comparing transcription density across conditions
 (e.g., control vs. stress) for the selected group of genes. The plot can
 either be displayed interactively or saved to a file.
}
\description{
This function plots metagene profiles based on transcript data, comparing
transcription density across conditions (e.g., control vs. stress). The
function allows the user to plot metagenes for different gene groups such as
attenuated genes, outgroup genes, the entire universe of genes, or all genes.
}
\details{
This function summarizes mean transcription levels across genomic coordinates
for different gene groups and plots the transcription density from the
transcription start site (TSS) to the transcription termination site (TTS).
The function can generate metagene plots for different gene groups such as
attenuated, outgroup, or all genes, and compares transcription profiles
between conditions (e.g., control vs. stress). The resulting plot helps
visualize differences in transcriptional response between groups of genes
under different conditions.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating necessary results
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)
rescountna <- countna(avfilt, expdf, nbcpu = 1, verbose = FALSE)
ecdf <- genesECDF(avfilt, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]
resmeandiff <- meandifference(resecdf, expdf, nbwindows,
    verbose = FALSE)
bytranslistmean <- split(resmeandiff, factor(resmeandiff$transcript))
resknee <- kneeid(bytranslistmean, expdf, verbose = FALSE)
resauc <- allauc(bytranslistmean, expdf, nbwindows, verbose = FALSE)
resatt <- attenuation(resauc, resknee, rescountna, bytranslistmean, expdf,
        resmeandiff, verbose = FALSE)
resug <- universegroup(resatt, expdf, verbose = FALSE)

## Testing plotmetagenes
plotmetagenes(resug, resmeandiff, expdf, plottype = "attenuation", plot = TRUE)

}
\seealso{
[universegroup], [meandifference]
}
