% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucarima.R, R/um.R
\name{autocorr.ucarima}
\alias{autocorr.ucarima}
\alias{autocorr}
\alias{autocorr.um}
\title{Theoretical simple/partial autocorrelations of an ARMA model}
\usage{
\method{autocorr}{ucarima}(x, ...)

autocorr(x, ...)

\method{autocorr}{um}(x, lag.max = 10, par = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{um}.}

\item{...}{additional arguments.}

\item{lag.max}{maximum lag for autocovariances.}

\item{par}{logical. If TRUE partial autocorrelations are computed.}
}
\value{
A numeric vector.
}
\description{
\code{autocorr} computes the simple/partial autocorrelations of an ARMA model.
}
\note{
The I polynomial is ignored.
}
\examples{
ar1 <- um(ar = "1-0.8B")
autocorr(ar1, lag.max = 13)
autocorr(ar1, lag.max = 13, par = TRUE)

}
