% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{residualisation}
\alias{residualisation}
\title{Performs matrix residualisation over estimated canonical vectors. There are
three types: basic (subtracts scaled estimated latent variable from data),
null (uses the null space of the estimated canonical vector to construct a
new matrix) and LV (uses SVD to residualise).}
\usage{
residualisation(
  mat,
  vec,
  spaceMat = NULL,
  type = c("LV", "null", "basic"),
  na.allow = TRUE
)
}
\arguments{
\item{mat}{An nxp matrix.}

\item{vec}{A vector of dimensions nxk.}

\item{spaceMat}{Only for "null" type residualisation. Default is NULL.}

\item{type}{Character. It can be LV, null or basic depending on which type of residualisation will be performed.}

\item{na.allow}{Logical. If TRUE, NAs will be allowed.}
}
\value{
Matrix.
}
\description{
Performs matrix residualisation over estimated canonical vectors. There are
three types: basic (subtracts scaled estimated latent variable from data),
null (uses the null space of the estimated canonical vector to construct a
new matrix) and LV (uses SVD to residualise).
}
