% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_research.r, R/shorthands.r
\name{tt_user_pinned_videos_api}
\alias{tt_user_pinned_videos_api}
\alias{tt_get_pinned}
\title{Lookup which videos were pinned by a user using the research API}
\usage{
tt_user_pinned_videos_api(
  username,
  fields = "all",
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)

tt_get_pinned(
  username,
  fields = "all",
  cache = TRUE,
  verbose = interactive(),
  token = NULL
)
}
\arguments{
\item{username}{vector of user names (handles) or URLs to users' pages.}

\item{fields}{The fields to be returned (defaults to all)}

\item{cache}{should progress be saved in the current session? It can then be
retrieved with \code{last_query()} if an error occurs. But the function
will use extra memory.}

\item{verbose}{should the function print status updates to the screen?}

\item{token}{The authentication token (usually supplied automatically after
running \link{auth_research} once).}
}
\value{
A data.frame of parsed TikTok videos the user has posted.
}
\description{
\ifelse{html}{\figure{api-research.svg}{options: alt='[Works on:
  Research API]'}}{\strong{[Works on: Research API]}}
}
\examples{
\dontrun{
tt_get_pinned("jbgruber")
# OR
tt_user_pinned_videos_api("https://www.tiktok.com/@tiktok")
# OR
tt_user_pinned_videos_api("https://www.tiktok.com/@tiktok")
}
}
