% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binderize.R
\name{binderize}
\alias{binderize}
\title{Prepare project for Binder}
\usage{
binderize(
  dockerfile = here::here("Dockerfile"),
  branch = "main",
  hub = "mybinder.org",
  urlpath = "rstudio",
  add_readme_badge = TRUE
)
}
\arguments{
\item{dockerfile}{Path to the tugboat-generated Dockerfile.}

\item{branch}{Character string specifying the Git branch, tag, or commit hash to build.
Defaults to \code{"main"}.}

\item{hub}{The Binder hub to use. Currently only \code{"mybinder.org"} is supported.}

\item{urlpath}{The URL path to open inside the Binder instance.
Defaults to \code{"rstudio"}, which opens an RStudio Server session.}

\item{add_readme_badge}{Logical. Whether to add a Binder launch badge to the README.
Defaults to \code{TRUE}.}
}
\value{
Invisibly returns \code{NULL}. Called primarily for its side effects of creating
Binder-related files and optionally committing them.
}
\description{
The \code{binderize()} function converts an existing tugboat project into a
\href{https://mybinder.org}{Binder}–compatible project by creating a Dockerfile
that launches RStudio Server via the \code{rocker/binder} base image.
Optionally, it can add a Binder launch badge to the project's README.
}
\details{
This enables one-click, cloud-based execution of your R analysis environment
directly from GitHub using Binder.

Currently only GitHub repositories are supported. If \code{add_readme_badge = TRUE},
a Binder badge will be appended to the README file, linking to the live Binder instance.
}
\note{
Binder can only build from the remote GitHub repository.
The \code{.binder/Dockerfile} and README changes must be committed and pushed before
launching Binder; otherwise, the build will not reflect local modifications.
}
\examples{
\dontrun{
binderize(
  dockerfile = here::here("Dockerfile"),
  branch = "main",
  add_readme_badge = TRUE
)
}

}
\seealso{
\itemize{
\item \code{\link[=create]{create()}} — Generates a Dockerfile from an analysis directory.
\item \code{\link[=build]{build()}} — Builds the corresponding Docker image locally.
}
}
