% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationships.R
\name{extract_relationships}
\alias{extract_relationships}
\title{Extract modern relationships from a Tableau TWB}
\usage{
extract_relationships(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\item{relationship_type}{Always "Relationship"}
\item{left_table}{Left table name}
\item{right_table}{Right table name}
\item{left_field}{Field name on left side}
\item{operator}{Join operator (e.g., "=")}
\item{right_field}{Field name on right side}
\item{left_is_calc}{Logical, whether left field is a calculation}
\item{right_is_calc}{Logical, whether right field is a calculation}
}
\description{
Parses Tableau "relationships" (introduced in 2020.2) between logical tables,
including the join predicate fields and operator.
}
\examples{

twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
extract_relationships(xml)


}
