

file_exts <- function (exts = NULL) {

    x <- rbind (
                c ('abap'        , 'ABAP'                  , '', '', '^\\\\\\*'),
                c ('ac'          , 'm4'                    , '', '', '^\\s*#'),
                c ('ada'         , 'Ada'                   , '', '', '^\\s*\\-\\-'),
                c ('adb'         , 'Ada'                   , '', '', '^\\s*\\-\\-'),
                c ('ads'         , 'Ada'                   , '', '', '^\\s*\\-\\-'),
                c ('adso'        , 'ADSO/IDSM'             , '', '', '^\\s*\\*[\\+\\!]'),
                c ('ahkl'        , 'AutoHotkey'            , '', '', '^\\s*;'),
                c ('ahk'         , 'AutoHotkey'            , '', '', '^\\s*;'),
                c ('aj'          , 'AspectJ'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('am'          , 'make'                  , '', '', '^\\s*#'),
                c ('ample'       , 'AMPLE'                 , '', '', '^\\s*\\/\\/'),
                c ('as'          , 'ActionScript'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('adoc'        , 'AsciiDoc'              , '\\/\\/\\/\\/', '\\/\\/\\/\\/', '^\\s*\\/\\/'),
                c ('asciidoc'    , 'AsciiDoc'              , '\\/\\/\\/\\/', '\\/\\/\\/\\/', '^\\s*\\/\\/'),
                c ('axd'         , 'ASP'                   , '', '', '^\\s\''),
                c ('ashx'        , 'ASP'                   , '', '', '^\\s\''),
                c ('asa'         , 'ASP'                   , '', '', '^\\s\''),
                c ('asax'        , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ascx'        , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('asd'         , 'Lisp'                  , '#\\|', '\\|#', ''),
                c ('nasm'        , 'Assembly'              , '', '', '^\\s*(#|;|\\@|\\||\\!)'),
                c ('a51'         , 'Assembly'              , '', '', '^\\s*(#|;|\\@|\\||\\!)'),
                c ('asm'         , 'Assembly'              , '', '', '^\\s*(#|;|\\@|\\||\\!)'),
                c ('asmx'        , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('asp'         , 'ASP'                   , '', '', '^\\s\''),
                c ('aspx'        , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('master'      , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sitemap'     , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cshtml'      , 'Razor'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('razor'       , 'Razor'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('nawk'        , 'awk'                   , '', '', '^\\s*#'),
                c ('mawk'        , 'awk'                   , '', '', '^\\s*#'),
                c ('gawk'        , 'awk'                   , '', '', '^\\s*#'),
                c ('auk'         , 'awk'                   , '', '', '^\\s*#'),
                c ('awk'         , 'awk'                   , '', '', '^\\s*#'),
                c ('bash'        , 'Bourne Again Shell'    , '', '', '^\\s*#'),
                c ('bazel'       , 'Starlark'              , '', '', '^\\s*#'),
                c ('BUILD'       , 'Bazel'                 , '', '', '^\\s*#'),
                c ('dxl'         , 'DOORS Extension Language', '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('bat'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('BAT'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('cmd'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('CMD'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('btm'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('BTM'         , 'DOS Batch'             , '', '', '^\\s*rem'),
                c ('blade'       , 'Blade'                 , '\\{\\{\\-\\-', '\\-\\-\\}\\}', ''),
                c ('blade.php'   , 'Blade'                 , '\\{\\{\\-\\-', '\\-\\-\\}\\}', ''),
                c ('brs'         , 'BrightScript'          , '', '', '^\\s*(rem|\')'),
                c ('bzl'         , 'Starlark'              , '', '', '^\\s*#'),
                c ('btp'         , 'BizTalk Pipeline'      , '<\\!\\-\\-', '\\-\\->', ''),
                c ('odx'         , 'BizTalk Orchestration' , '', '', '^\\s*#'),
                c ('idc'         , 'C'                     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cats'        , 'C'                     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('c'           , 'C'                     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tpp'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tcc'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ipp'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('inl'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('h++'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('C'           , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cc'          , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('c++'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ccs'         , 'CCS'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cfc'         , 'ColdFusion CFScript'   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cfml'        , 'ColdFusion'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cfm'         , 'ColdFusion'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('chpl'        , 'Chapel'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cl'          , 'Lisp/OpenCL'           , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('riemann.config', 'Clojure'               , '', '', '^\\s*#'),
                c ('hic'         , 'Clojure'               , '', '', '^\\s*#'),
                c ('cljx'        , 'Clojure'               , '', '', '^\\s*#'),
                c ('cljscm'      , 'Clojure'               , '', '', '^\\s*#'),
                c ('cljs.hl'     , 'Clojure'               , '', '', '^\\s*#'),
                c ('cl2'         , 'Clojure'               , '', '', '^\\s*#'),
                c ('boot'        , 'Clojure'               , '', '', '^\\s*#'),
                c ('clj'         , 'Clojure'               , '', '', '^\\s*#'),
                c ('cls'         , 'Visual Basic/TeX/Apex Class' , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cmake.in'    , 'CMake'                 , '', '', '^\\s*#'),
                c ('CMakeLists.txt' , 'CMake'              , '', '', '^\\s*#'),
                c ('cmake'       , 'CMake'                 , '', '', '^\\s*#'),
                c ('iced'        , 'CoffeeScript'          , '', '', '^\\s*#'),
                c ('cjsx'        , 'CoffeeScript'          , '', '', '^\\s*#'),
                c ('cakefile'    , 'CoffeeScript'          , '', '', '^\\s*#'),
                c ('_coffee'     , 'CoffeeScript'          , '', '', '^\\s*#'),
                c ('coffee'      , 'CoffeeScript'          , '', '', '^\\s*#'),
                c ('component'   , 'Visualforce Component' , '<\\!\\-\\-', '\\-\\->', ''),
                c ('cpp'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('CPP'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cr'          , 'Crystal'               , '', '', '^\\s*#'),
                c ('cs'          , 'C#/Smalltalk'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('designer.cs' , 'C# Designer'           , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cake'        , 'Cake Build Script'     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('csh'         , 'C Shell'               , '', '', '^\\s*#'),
                c ('cson'        , 'CSON'                  , '', '', '^\\s*#'),
                c ('css'         , "CSS"                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cu'          , 'CUDA'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cuh'         , 'CUDA'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cxx'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('dart'        , 'Dart'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('def'         , 'Windows Module Definition', '', '', '^\\s*;'),
                c ('dhall'       , 'dhall'                 , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('dt'          , 'DIET'                  , '', '', '^\\s*\\/\\/'),
                c ('patch'       , 'diff'                  , '^\\-\\-\\-', '^\\-\\-\\-', '^(#|\\s)'),
                c ('dmap'        , 'NASTRAN DMAP'          , '', '', '^\\s*\\$'),
                c ('sthlp'       , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('matah'       , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('mata'        , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ihlp'        , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('doh'         , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ado'         , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('do'          , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('DO'          , 'Stata'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('pascal'      , 'Pascal'                , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('lpr'         , 'Pascal'                , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('dfm'         , 'Delphi Form'           , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('dpr'         , 'Pascal'                , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('dita'        , 'DITA'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('drl'         , 'Drools'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('dtd'         , 'DTD'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ec'          , 'C'                     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ecpp'        , 'ECPP'                  , '<#', '#>', ''),
                c ('eex'         , 'EEx'                   , '<%#', '%>', ''),
                c ('el'          , 'Lisp'                  , '#\\|', '\\|#', ''),
                c ('elm'         , 'Elm'                   , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('exs'         , 'Elixir'                , '', '', '^\\s*#'),
                c ('ex'          , 'Elixir'                , '', '', '^\\s*#'),
                c ('ecr'         , 'Embedded Crystal'      , '<%#', '%>', ''),
                c ('ejs'         , 'EJS'                   , '<%#', '%>', ''),
                c ('erb'         , 'ERB'                   , '<%#', '%>', ''),
                c ('ERB'         , 'ERB'                   , '<%#', '%>', ''),
                c ('yrl'         , 'Erlang'                , '', '', '^\\s*%'),
                c ('xrl'         , 'Erlang'                , '', '', '^\\s*%'),
                c ('rebar.lock'  , 'Erlang'                , '', '', '^\\s*%'),
                c ('rebar.config.lock', 'Erlang'           , '', '', '^\\s*%'),
                c ('rebar.config', 'Erlang'                , '', '', '^\\s*%'),
                c ('emakefile'   , 'Erlang'                , '', '', '^\\s*%'),
                c ('app.src'     , 'Erlang'                , '', '', '^\\s*%'),
                c ('erl'         , 'Erlang'                , '', '', '^\\s*%'),
                c ('exp'         , 'Expect'                , '', '', '^\\s*#'),
                c ('fish'        , 'Fish Shell'            , '', '', '^\\s*#'),
                c ('fnl'         , 'Fennel'                , '', '', '^\\s*;'),
                c ('fsi'         , 'F#'                    , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('gnumakefile' , 'make'                  , '', '', '^\\s*#'),
                c ('Gnumakefile' , 'make'                  , '', '', '^\\s*#'),
                c ('gd'          , 'GDScript'              , '', '', '^\\s*#'),
                c ('vshader'     , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vsh'         , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vrx'         , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('gshader'     , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('glslv'       , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('geo'         , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('fshader'     , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('fsh'         , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('frg'         , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('fp'          , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('glsl'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('graphqls'    , 'GraphQL'               , '', '', '^\\s*#'),
                c ('gql'         , 'GraphQL'               , '', '', '^\\s*#'),
                c ('graphql'     , 'GraphQL'               , '', '', '^\\s*#'),
                c ('vert'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tesc'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tese'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('geom'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('feature'     , 'Cucumber'              , '', '', '^\\s*#'),
                c ('frag'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('comp'        , 'GLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('g'           , 'ANTLR Grammar'         , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('g4'          , 'ANTLR Grammar'         , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('gleam'       , 'Gleam'                 , '', '', '^\\s*\\/\\/'),
                c ('go'          , 'Go'                    , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('gsp'         , 'Grails'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('h'           , 'C/C++ Header'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('H'           , 'C/C++ Header'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hh'          , 'C/C++ Header'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hpp'         , 'C/C++ Header'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hxx'         , 'C/C++ Header'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hrl'         , 'Erlang'                , '', '', '^\\s*%'),
                c ('hsc'         , 'Haskell'               , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('hs'          , 'Haskell'               , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('tfvars'      , 'HCL'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hcl'         , 'HCL'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tf'          , 'HCL'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('nomad'       , 'HCL'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hlsli'       , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('fxh'         , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hlsl'        , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('shader'      , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cg'          , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('cginc'       , 'HLSL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('handlebars'  , 'Handlebars'            , '\\{\\{\\!|<\\!\\-\\-', '\\-\\-\\}\\}|\\-\\-\\>', ''),
                c ('hbs'         , 'Handlebars'            , '\\{\\{\\!|<\\!\\-\\-', '\\-\\-\\}\\}|\\-\\-\\>', ''),
                c ('hxsl'        , 'Haxe'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hx'          , 'Haxe'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('xht'         , 'HTML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('html.hl'     , 'HTML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('htm'         , 'HTML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('html'        , 'HTML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ice'         , 'Slice'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('icl'         , 'Clean'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('dcl'         , 'Clean'                 , '\\/\\*', '\\*\\/', '^\\s*^\\s*\\/\\/'),
                c ('dlm'         , 'IDL'                   , '', '', '^\\s*;'),
                c ('idl'         , 'IDL'                   , '', '', '^\\s*;'),
                c ('idr'         , 'Idris'                 , '', '', '^\\s*\\|'),
                c ('lidr'        , 'Literate Idris'        , '', '', '^[^>]'),
                c ('imba'        , 'Imba'                  , '', '', '^\\s*#'),
                c ('prefs'       , 'INI'                   , '', '', '^\\s*;'),
                c ('lektorproject', 'INI'                  , '', '', '^\\s*;'),
                c ('buildozer.spec', 'INI'                 , '', '', '^\\s*;'),
                c ('ini'         , 'INI'                   , '', '', '^\\s*;'),
                c ('ism'         , 'InstallShield'         , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ipl'         , 'IPL'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('inc'         , 'PHP/Pascal'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('inl'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ino'         , 'Arduino Sketch'        , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ipf'         , 'Igor Pro'              , '', '', '^\\s*\\/\\/'),
                c ('pde'         , 'Arduino Sketch'        , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('java'        , 'Java'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jcl'         , 'JCL'                   , '', '', '^\\s*\\/\\/'),
                c ('xsjslib'     , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('xsjs'        , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ssjs'        , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sjs'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('pac'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('njs'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('mjs'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jss'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsm'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsfl'        , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jscad'       , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsb'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jakefile'    , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jake'        , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('bones'       , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('_js'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('js'          , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('es6'         , 'JavaScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsf'         , 'JavaServer Faces'      , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsx'         , 'JSX'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('xhtml'       , 'XHTML'                 , '<\\!\\-\\-', '\\-\\->', ''),
                c ('jinja'       , 'Jinja Template'        , '\\{\\#', '\\#\\}', ''),
                c ('jinja2'      , 'Jinja Template'        , '\\{\\#', '\\#\\}', ''),
                c ('json5'       , 'JSON5'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jsp'         , 'JSP'                   , '<\\!\\-\\-', '\\-\\->', '^\\s*\\/\\/'),
                c ('jspf'        , 'JSP'                   , '<\\!\\-\\-', '\\-\\->', '^\\s*\\/\\/'),
                c ('junos'       , 'Juniper Junos'         , '', '', '^\\s*#'),
                c ('ksc'         , 'Kermit'                , '', '', '^\\s*#'),
                c ('ktm'         , 'Kotlin'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('kt'          , 'Kotlin'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('kts'         , 'Kotlin'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('hlean'       , 'Lean'                  , '\\/\\-', '\\-\\.', '^\\s*\\-\\-'),
                c ('lean'        , 'Lean'                  , '\\/\\-', '\\-\\.', '^\\s*\\-\\-'),
                c ('lhs'         , 'Haskell'               , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('lex'         , 'lex'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('l'           , 'lex'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('less'        , 'LESS'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('lfe'         , 'LFE'                   , '\\#\\|', '\\|\\#', '^\\s*;'),
                c ('liquid'      , 'liquid'                , '\\{% comment %\\}', '\\{% endcomment %\\}', ''),
                c ('lsp'         , 'Lisp'                  , '#\\|', '\\|#', ''),
                c ('lisp'        , 'Lisp'                  , '#\\|', '\\|#', ''),
                c ('m4'          , 'm4'                    , '', '', '^\\s*#'),
                c ('makefile'    , 'make'                  , '', '', '^\\s*#'),
                c ('Makefile'    , 'make'                  , '', '', '^\\s*#'),
                c ('mc'          , 'Windows Message File'  , '', '', '^\\s*\\/\\/'),
                c ('meson.build' , 'Meson'                 , '', '', '^\\s*#'),
                c ('mk'          , 'make'                  , '', '', '^\\s*#'),
                c ('mm'          , 'Objective-C++'         , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('msg'         , 'Gencat NLS'            , '', '', '^\\$'),
                c ('nbp'         , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('mathematica' , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('ma'          , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('cdf'         , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('mt'          , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('wl'          , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('wlt'         , 'Mathematica'           , '\\(\\*', '\\*\\)', ''),
                c ('wdproj'      , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('csproj'      , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vcproj'      , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wixproj'     , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('btproj'      , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('msbuild'     , 'MSBuild script'        , '<\\!\\-\\-', '\\-\\->', ''),
                c ('sln'         , 'Visual Studio Solution', '', '', '^\\s*#'),
                c ('mth'         , 'Teamcenter mth'        , '', '', '^\\s*#'),
                c ('n'           , 'Nemerle'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('nix'         , 'Nix'                   , '', '', '^\\s*#'),
                c ('nut'         , 'Squirrel'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('odin'        , 'Odin'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('oscript'     , 'LiveLink OScript'      , '', '', '^\\s*\\/\\/'),
                c ('pad'         , 'Ada'                   , '', '', '^\\s*\\-\\-'),
                c ('page'        , 'Visualforce Page'      , '<\\!\\-\\-', '\\-\\->', ''),
                c ('pas'         , 'Pascal'                , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('pcc'         , 'C++'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rexfile'     , 'Perl'                  , '', '', '^\\s*#'),
                c ('psgi'        , 'Perl'                  , '', '', '^\\s*#'),
                c ('ph'          , 'Perl'                  , '', '', '^\\s*#'),
                c ('makefile.pl' , 'Perl'                  , '', '', '^\\s*#'),
                c ('cpanfile'    , 'Perl'                  , '', '', '^\\s*#'),
                c ('al'          , 'Perl'                  , '', '', '^\\s*#'),
                c ('ack'         , 'Perl'                  , '', '', '^\\s*#'),
                c ('perl'        , 'Perl'                  , '', '', '^\\s*#'),
                c ('pgc'         , 'C'                     , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('phpt'        , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('phps'        , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('phakefile'   , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ctp'         , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('aw'          , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php_cs.dist' , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php_cs'      , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php3'        , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php4'        , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php5'        , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('php'         , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('phtml'       , 'PHP'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('plh'         , 'Perl'                  , '', '', '^\\s*#'),
                c ('plx'         , 'Perl'                  , '', '', '^\\s*#'),
                c ('pm'          , 'Perl'                  , '', '', '^\\s*#'),
                c ('pm6'         , 'Raku'                  , '', '', '^\\s*#'),
                c ('raku'        , 'Raku'                  , '', '', '^\\s*#'),
                c ('rakumod'     , 'Raku'                  , '', '', '^\\s*#'),
                c ('pom.xml'     , 'Maven'                 , '<\\!\\-\\-', '\\-\\->', ''),
                c ('pom'         , 'Maven'                 , '<\\!\\-\\-', '\\-\\->', ''),
                c ('p'           , 'Pascal'                , '\\(\\*', '\\*\\)', '^\\s*\\/\\/'),
                c ('xpy'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('wsgi'        , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('wscript'     , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('workspace'   , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('tac'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('snakefile'   , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('sconstruct'  , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('sconscript'  , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyt'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyp'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyi'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyde'        , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('py3'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('lmi'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('gypi'        , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('gyp'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('build.bazel' , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('buck'        , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('gclient'     , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('py'          , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyw'         , 'Python'                , '\\/\\*', '\\*\\/', '^\\s*#'),
                c ('pyj'         , 'RapydScript'           , '', '', '^\\s*#'),
                c ('pxi'         , 'Cython'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('pxd'         , 'Cython'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('pyx'         , 'Cython'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('qbs'         , 'QML'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('qml'         , 'QML'                   , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('watchr'      , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('vagrantfile' , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('thorfile'    , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('thor'        , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('snapfile'    , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('ru'          , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rbx'         , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rbw'         , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rbuild'      , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rabl'        , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('puppetfile'  , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('podfile'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('mspec'       , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('mavenfile'   , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('jbuilder'    , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('jarfile'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('guardfile'   , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('god'         , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('gemspec'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('gemfile.lock', 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('gemfile'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('fastfile'    , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('eye'         , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('deliverfile' , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('dangerfile'  , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('capfile'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('buildfile'   , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('brewfile'    , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('berksfile'   , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('appraisals'  , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('pryrc'       , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('irbrc'       , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rb'          , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('podspec'     , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rake'        , 'Ruby'                  , '^\\=begin', '^\\=end', '^\\s*#'),
                c ('rhtml'       , 'Ruby HTML'             , '<\\!\\-\\-', '\\-\\->', ''),
                c ('rs.in'       , 'Rust'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rs'          , 'Rust'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('s'           , 'Assembly'              , '', '', '^\\s*(#|;|\\@|\\||\\!)'),
                c ('S'           , 'Assembly'              , '', '', '^\\s*(#|;|\\@|\\||\\!)'),
                c ('sbt'         , 'Scala'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('kojo'        , 'Scala'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('scala'       , 'Scala'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sed'         , 'sed'                   , '', '', '^\\s*#'),
                c ('ses'         , 'Patran Command Language'   , '', '', '^\\s*#'),
                c ('sp'          , 'SparForte'             , '', '', '^\\s*(#\\!|\\-\\-)'),
                c ('sol'         , 'Solidity'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('pcl'         , 'Patran Command Language'   , '', '', '^\\s*#'),
                c ('pl1'         , 'PL/I'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('plm'         , 'PL/M'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('lit'         , 'PL/M'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('po'          , 'PO File'               , '', '', '^\\s*#'),
                c ('pbt'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sra'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('srf'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('srm'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('srs'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sru'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('srw'         , 'PowerBuilder'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('jade'        , 'Pug'                   , '', '', '^\\s*\\/\\/'),
                c ('pug'         , 'Pug'                   , '', '', '^\\s*\\/\\/'),
                c ('purs'        , 'PureScript'            , '\\{\\-', '\\-\\}', '^\\s*\\-\\-'),
                c ('prefab'      , 'Unity-Prefab'          , '', '', '^\\s*#'),
                c ('proto'       , 'Protocol Buffers'      , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('mat'         , 'Unity-Prefab'          , '', '', '^\\s*#'),
                c ('ps1'         , 'PowerShell'            , '', '', '^\\s*#'),
                c ('psd1'        , 'PowerShell'            , '', '', '^\\s*#'),
                c ('psm1'        , 'PowerShell'            , '', '', '^\\s*#'),
                c ('rsx'         , 'R'                     , '', '', '^\\s*#'),
                c ('rd'          , 'R'                     , '', '', '^\\s*#'),
                c ('expr-dist'   , 'R'                     , '', '', '^\\s*#'),
                c ('rprofile'    , 'R'                     , '', '', '^\\s*#'),
                c ('R'           , 'R'                     , '', '', '^\\s*#'),
                c ('r'           , 'R'                     , '', '', '^\\s*#'),
                c ('raml'        , 'RAML'                  , '', '', '^\\s*#'),
                c ('ring'        , 'Ring'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rh'          , 'Ring'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rform'       , 'Ring'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('Rmd'         , 'Rmd'                   , '', '', '^\\s*#'),
                c ('re'          , 'ReasonML'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rei'         , 'ReasonML'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('res'         , 'ReScript'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('resi'        , 'ReScript'              , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('robot'       , 'RobotFramework'        , '', '', '^\\s*(#|comment)'),
                c ('rc'          , 'Windows Resource File' , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('rc2'         , 'Windows Resource File' , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sass'        , 'Sass'                  , '', '', '^\\s*\\/\\/'),
                c ('scss'        , 'Sass'                  , '', '', '^\\s*\\/\\/'),
                c ('sh'          , 'Bourne Shell'          , '', '', '^\\s*#'),
                c ('e'           , 'Specman e'             , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sss'         , 'SugarSS'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('styl'        , 'Stylus'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('i'           , 'SWIG'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('svelte'      , 'Svelte'                , '<\\!\\-\\-', '\\-\\->', ''),
                c ('sv'          , 'Verilog-SystemVerilog' , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('svh'         , 'Verilog-SystemVerilog' , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('svg'         , 'SVG'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('SVG'         , 'SVG'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tcsh'        , 'C Shell'               , '', '', '^\\s*#'),
                c ('mkvi'        , 'TeX'                   , '', '', '^\\s*%'),
                c ('mkiv'        , 'TeX'                   , '', '', '^\\s*%'),
                c ('mkii'        , 'TeX'                   , '', '', '^\\s*%'),
                c ('ltx'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('lbx'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('ins'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('cbx'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('bib'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('bbx'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('aux'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('tex'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('toml'        , 'TOML'                  , '', '', '^\\s*#'),
                c ('sty'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('dtx'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('bst'         , 'TeX'                   , '', '', '^\\s*%'),
                c ('tres'        , 'Godot Resource'        , '', '', '^\\s*;'),
                c ('tscn'        , 'Godot Scene'           , '', '', '^\\s*;'),
                c ('thrift'      , 'Thrift'                , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('trigger'     , 'Apex Trigger'          , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ttcn'        , 'TTCN'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ttcn2'       , 'TTCN'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ttcn3'       , 'TTCN'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('ttcnpp'      , 'TTCN'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('sdl'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('ssc'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('sdt'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('spd'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('sst'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('rou'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('cin'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('cii'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('interface'   , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('in1'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('in2'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('in3'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('in4'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('inf'         , 'TNSDL'                 , '\\/\\*', '\\*\\/', ''),
                c ('tpd'         , 'TITAN Project File Information', '<\\!\\-\\-', '\\-\\->', ''),
                c ('ts'          , 'TypeScript/Qt Linguist', '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('tsx'         , 'TypeScript'            , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('glade'       , 'Glade'                 , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vala'        , 'Vala'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vapi'        , 'Vala Header'           , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhw'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vht'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhs'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vho'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhi'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhf'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhd'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('VHD'         , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vhdl'        , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('VHDL'        , 'VHDL'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vue'         , 'Vuejs Component'       , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('webinfo'     , 'ASP.NET'               , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('wsdl'        , 'Web Services Description', '<\\!\\-\\-', '\\-\\->', ''),
                c ('x'           , 'Logos'                 , '', '', '^\\s*#'),
                c ('xm'          , 'Logos'                 , '', '', '^\\s*#'),
                c ('xmi'         , 'XMI'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('XMI'         , 'XMI'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('zcml'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xul'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xspec'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xproj'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xml.dist'    , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xliff'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xlf'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xib'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xacro'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('x3d'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wsf'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('web.release.config', 'XML'             , '<\\!\\-\\-', '\\-\\->', ''),
                c ('web.debug.config', 'XML'               , '<\\!\\-\\-', '\\-\\->', ''),
                c ('web.config'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wxml'        , 'WXML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wxss'        , 'WXSS'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('vxml'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vstemplate'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vssettings'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vsixmanifest', 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('vcxproj'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ux'          , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('urdf'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tmtheme'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tmsnippet'   , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tmpreferences', 'XML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tmlanguage'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tml'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('tmcommand'   , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('targets'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('sublime-snippet', 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('sttheme'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('storyboard'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('srdf'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('shproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('sfproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('settings.stylecop', 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('scxml'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('rss'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('resx'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('rdf'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('pt'          , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('psc1'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ps1xml'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('props'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('proj'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('plist'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('pkgproj'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('packages.config', 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('osm'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('odd'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('nuspec'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('nuget.config', 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('nproj'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ndproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('natvis'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('mjml'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('mdpolicy'    , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('launch'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('kml'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('jsproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('jelly'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ivy'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('iml'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('grxml'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('gmx'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('fsproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('filters'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('dotsettings' , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('dll.config'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ditaval'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ditamap'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('depproj'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ct'          , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('csl'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('csdef'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('cscfg'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('cproject'    , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('clixml'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ccxml'       , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ccproj'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('builds'      , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('axml'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('app.config'  , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('ant'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('admx'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('adml'        , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('project'     , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('classpath'   , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xml'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('XML'         , 'XML'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('build'       , 'NAnt script'           , '<\\!\\-\\-', '\\-\\->', ''),
                c ('swift'       , 'Swift'                 , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('xaml'        , 'XAML'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wast'        , 'WebAssembly'           , '', '', '^\\s*;;'),
                c ('wat'         , 'WebAssembly'           , '', '', '^\\s*;;'),
                c ('wxs'         , 'WiX source'            , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wxi'         , 'WiX include'           , '<\\!\\-\\-', '\\-\\->', ''),
                c ('wxl'         , 'WiX string localization' , '<\\!\\-\\-', '\\-\\->', ''),
                c ('prw'         , 'xBase'                 , '\\/\\*', '\\*\\/', '^\\s*(&&|\\*|NOTE|note|Note'),
                c ('prg'         , 'xBase'                 , '\\/\\*', '\\*\\/', '^\\s*(&&|\\*|NOTE|note|Note'),
                c ('ch'          , 'xBase Header'          , '\\/\\*', '\\*\\/', '^\\s*(&&|\\*|NOTE|note|Note'),
                c ('xqy'         , 'XQuery'                , '\\(\\:', '\\:\\)', ''),
                c ('xqm'         , 'XQuery'                , '\\(\\:', '\\:\\)', ''),
                c ('xql'         , 'XQuery'                , '\\(\\:', '\\:\\)', ''),
                c ('xq'          , 'XQuery'                , '\\(\\:', '\\:\\)', ''),
                c ('xquery'      , 'XQuery'                , '\\(\\:', '\\:\\)', ''),
                c ('xsd'         , 'XSD'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('XSD'         , 'XSD'                   , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xslt'        , 'XSLT'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('XSLT'        , 'XSLT'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('xsl'         , 'XSLT'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('XSL'         , 'XSLT'                  , '<\\!\\-\\-', '\\-\\->', ''),
                c ('yacc'        , 'yacc'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('y'           , 'yacc'                  , '\\/\\*', '\\*\\/', '^\\s*\\/\\/'),
                c ('yml.mysql'   , 'YAML'                  , '', '', '^\\s*#'),
                c ('yaml-tmlanguage', 'YAML'                  , '', '', '^\\s*#'),
                c ('syntax'      , 'YAML'                  , '', '', '^\\s*#'),
                c ('sublime-syntax', 'YAML'                  , '', '', '^\\s*#'),
                c ('rviz'        , 'YAML'                  , '', '', '^\\s*#'),
                c ('reek'        , 'YAML'                  , '', '', '^\\s*#'),
                c ('mir'         , 'YAML'                  , '', '', '^\\s*#'),
                c ('glide.lock'  , 'YAML'                  , '', '', '^\\s*#'),
                c ('gemrc'       , 'YAML'                  , '', '', '^\\s*#'),
                c ('clang-tidy'  , 'YAML'                  , '', '', '^\\s*#'),
                c ('clang-format', 'YAML'                  , '', '', '^\\s*#'),
                c ('yaml'        , 'YAML'                  , '', '', '^\\s*#'),
                c ('yml'         , 'YAML'                  , '', '', '^\\s*#'),
                c ('zig'         , 'Zig'                   , '', '', '^\\s*\\/\\/'),
                c ('zsh'         , 'zsh'                   , '', '', '^\\s*#')
    )

    x <- data.frame (x)
    names (x) <- c ("ext", "type", "cmt_open", "cmt_close", "cmt")

    # add '.q' files because BDR uses these (for example, in 'boot'):
    x <- rbind (x, c ('q', 'R', '', '', '^\\s*#'))

    if (!is.null (exts)) {

        x <- x [match (exts, x$ext), ]
    }

    return (x)
}
