% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LeveneTest.R
\name{Levene.Test}
\alias{Levene.Test}
\title{Levene's Test for Homogeneity of Variances (Manual Implementation) v2.1}
\usage{
Levene.Test(
  formula,
  data,
  alpha = 0.05,
  center = "median",
  decompose = TRUE,
  anova_type = c("I", "II", "III")
)
}
\arguments{
\item{formula}{y ~ factors (e.g., y ~ A or y ~ A * B).}

\item{data}{data.frame with variables in the formula.}

\item{alpha}{Significance level (default 0.05).}

\item{center}{"median" (Brown-Forsythe, default) or "mean" (classical Levene).}

\item{decompose}{logical. If TRUE and there are >= 2 factors, run ANOVA on |Y - cell_center|.}

\item{anova_type}{"I", "II" (2-way only) or "III" (any number of factors, no 'car').}
}
\value{
An object of class \code{"homocedasticidad"}, containing:
\describe{
  \item{Statistic}{F statistic of the Levene test.}
  \item{df}{Degrees of freedom (between and within groups).}
  \item{p_value}{The p-value for the test.}
  \item{Decision}{\code{"Homoscedastic"} or \code{"Heteroscedastic"} depending on the test result.}
  \item{Method}{A string indicating the method used ("Levene").}
}
}
\description{
Performs Levene's test for equality of variances across groups using a formula interface.
This test evaluates the null hypothesis that the variances are equal across groups,
and is commonly used as a preliminary test before ANOVA or other parametric analyses.
}
\details{
Levene's test is based on an analysis of variance (ANOVA) applied to the absolute deviations
from each group's center (either the mean or, more robustly, the median).
It is less sensitive to departures from normality than Bartlett's test.

Advantages:
- Robust to non-normality, especially when using the median.
- Suitable for equal or unequal sample sizes across groups.
- Widely used in practice for checking homoscedasticity.

Disadvantages:
- Less powerful than parametric alternatives under strict normality.
}
\examples{
data(d_e, package = "Analitica")
res <- Levene.Test(Sueldo_actual ~ as.factor(labor), data = d_e)
summary(res)

# RCBD
resB<-Levene.Test(Sueldo_actual ~ as.factor(labor)+Sexo, data = d_e)
summary(resB)

# anova 2-ways
resC<-Levene.Test(Sueldo_actual ~ as.factor(labor)*Sexo, data = d_e)
summary(resC)

}
\references{
Levene, H. (1960). "Robust Tests for Equality of Variances." In Contributions to Probability and Statistics: Essays in Honor of Harold Hotelling (pp.278-292). Stanford University Press.
}
