% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGVAR.R
\name{coef}
\alias{coef}
\alias{coef.bgvar}
\alias{coefficients.bgvar}
\title{Extract Model Coefficients of Bayesian GVAR}
\usage{
\method{coef}{bgvar}(object, ..., quantile = 0.5)

\method{coefficients}{bgvar}(object, ..., quantile = 0.5)
}
\arguments{
\item{object}{An object of class \code{bgvar}.}

\item{...}{Additional arguments.}

\item{quantile}{reported quantiles. Default is set to the median.}
}
\value{
Returns an \code{q} times \code{K} times \code{K} times \code{p} array of the global coefficients, where \code{q} is the number of specified quantiles (this dimension is dropped if \code{q=1}), \code{K} the number of endogenous variables and \code{p} number of lags.
}
\description{
Extracts the global model coefficients for \code{bgvar} for certain quantiles of the posterior distribution. \code{coefficients} is an \emph{alias} for it.
}
\examples{
\donttest{
library(BGVAR)
data(testdata)
model.ng <- bgvar(Data=testdata,W=W.test,plag=1,draws=100,burnin=100)
coef(model.ng)
}
\donttest{
coefficients(model.ng)
}
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
