% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreate_hdf5_group}
\alias{bdCreate_hdf5_group}
\title{Create Group in an HDF5 File}
\usage{
bdCreate_hdf5_group(filename, group)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Group path to create
(e.g., \code{"MGCCA_OUT/scores"}).}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{gr}{Character string with the full group path created within the
HDF5 file}
}
}
\description{
Create a (nested) group inside an HDF5 file. The operation is
idempotent: if the group already exists, no error is raised.
}
\details{
Intermediate groups are created when needed. The HDF5 file must
exist prior to the call (create it with a writer function).
}
\examples{
\dontrun{
library(BigDataStatMeth)
fn <- "test.hdf5"

# Ensure file exists (e.g., by creating an empty dataset or via a helper)
mat <- matrix(0, nrow = 1, ncol = 1)
bdCreate_hdf5_matrix(fn, mat, group = "tmp", dataset = "seed",
                     overwriteFile = TRUE)

# Create nested group
bdCreate_hdf5_group(fn, "MGCCA_OUT/scores")
}

}
\references{
The HDF Group. HDF5 User's Guide.
}
\seealso{
\code{\link{bdCreate_hdf5_matrix}}, \code{\link{bdRemove_hdf5_element}}
}
