% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gauss_test_power.R
\name{Gauss_test_powerAnalysis}
\alias{Gauss_test_powerAnalysis}
\title{Computation of uniformly valid power and sufficient sample size for the one-sided Gauss test}
\usage{
Gauss_test_powerAnalysis(
  eta = NULL,
  n = NULL,
  beta = NULL,
  alpha = 0.05,
  K4 = 9,
  kappa = 0.99
)
}
\arguments{
\item{eta}{the effect size \eqn{\eta} that
characterizes the alternative hypothesis}

\item{n}{sample size}

\item{beta}{the power of detecting the effect \code{eta} using the sample size \code{n}}

\item{alpha}{the level of the test}

\item{K4}{the kurtosis of the \eqn{X_i}}

\item{kappa}{Regularity parameter of the distribution of the \eqn{X_i}
It corresponds to a bound on the modulus of the characteristic function
\eqn{f_{X_n / \sigma_n}(t)} of the standardized \eqn{X_n}.
More precisely, \code{kappa} is an upper bound on
\eqn{kappa :=} sup of modulus of \eqn{f_{X_n / \sigma_n}(t)}
over all \eqn{t} such that \eqn{|t| \geq 2 t_1^* \pi / K3tilde}.}
}
\value{
The computed value of either the sufficient sample size \code{n},
or the minimum effect size \code{eta}, or the power \code{beta}.
}
\description{
Let \eqn{X_1, \dots, X_n} be \eqn{n} i.i.d. variables
with mean \eqn{\mu}, variance \eqn{\sigma^2}.
Assume that we want to test the hypothesis
\eqn{H_0: \mu \leq \mu_0} against the alternative \eqn{H_1: \mu \leq \mu_0}.
For this, we want to use the classical Gauss test, which rejects the null hypothesis
if \eqn{\sqrt{n}(\bar{X}_n - \mu)} is larger than the quantile of the Gaussian
distribution at level \eqn{1 - \alpha}.
Let \eqn{\eta := (\mu - \mu_0) / \sigma} be the effect size,
i.e. the distance between the null and the alternative hypotheses,
measured in terms of standard deviations.
Let \code{beta} be the uniform power of this test:
\deqn{beta = \inf_{H_1} \textrm{Prob}(\textrm{Rejection}),}
where the infimum is taken over all distributions under the alternative hypothesis, i.e.
that have mean \eqn{\mu = \mu_0 + \eta \sigma}, bounded kurtosis \code{K4},
and that satisfy the regularity condition \code{kappa} described below.
This means that this power \code{beta} is uniformly valid over
a large (infinite-dimensional) class of alternative distributions,
much beyond the Gaussian family even though the test is based on the Gaussian quantile.
There is a relation between the sample size \code{n}, the effect size \code{eta}
and the uniform power \code{beta} of this test.
This function takes as an input two of the three quantities
(the sample size \code{n}, the effect size \code{eta}, and the uniform power
\code{beta}) and return the other one.
}
\details{
This function can be used to plan experiments, for example to know what would
be a sufficient sample size to attain a fixed power against a given effect size
that the researcher would like to detect.

Note that the results given by this function are formally valid only for the
Gauss test (i.e., when the variance of the distribution is assumed to be known).
}
\examples{

# Sufficient sample size to detect an effect of 0.5 standard deviation with probability 80\%
Gauss_test_powerAnalysis(eta = 0.5, beta = 0.8)
# We can detect an effect of 0.5 standard deviations with probability 80\% for n >= 548

# Power of an experiment to detect an effect of 0.5 with a sample size of n = 800
Gauss_test_powerAnalysis(eta = 0.5, n = 800)
# We can detect an effect of 0.5 standard deviations with probability 85.1\% for n = 800

# Smallest effect size that can be detected with a probability of 80\% for a sample size of n = 800
Gauss_test_powerAnalysis(n = 800, beta = 0.8)
# We can detect an effect of 0.114 standard deviations with probability 80\% for n = 800


}
\references{
Derumigny A., Girard L., and Guyonvarch Y. (2023).
Explicit non-asymptotic bounds for the distance to the first-order Edgeworth expansion,
Sankhya A. \doi{10.1007/s13171-023-00320-y}
\href{https://arxiv.org/abs/2101.05780}{arxiv:2101.05780}.
}
