% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_wbt_catchment.R
\name{ch_wbt_catchment}
\alias{ch_wbt_catchment}
\title{Delineate catchment boundaries}
\usage{
ch_wbt_catchment(
  fn_pp_snap,
  fn_flowdir,
  fn_catchment_ras,
  fn_catchment_vec,
  return_vector = TRUE
)
}
\arguments{
\item{fn_pp_snap}{Name of file containing snapped pour points}

\item{fn_flowdir}{Name of file containing flow accumulations.}

\item{fn_catchment_ras}{Raster file to contain delineated catchment.}

\item{fn_catchment_vec}{Vector file to contain delineated catchment.}

\item{return_vector}{If \code{TRUE} (the default) a vector of the catchment will be returned.}
}
\value{
If \code{return_vector == TRUE} a vector of the catchment is returned. Otherwise
nothing is returned.
}
\description{
Delineate catchment boundaries
}
\examples{
# Only proceed if Whitebox executable is installed
library(whitebox)
if (check_whitebox_binary()){
  library(raster)
  test_raster <- ch_volcano_raster()
  dem_raster_file <- tempfile(fileext = ".tif")
  no_sink_raster_file <- tempfile("no_sinks", fileext = ".tif")

  # write test raster to file
  writeRaster(test_raster, dem_raster_file, format = "GTiff")

  # remove sinks
  removed_sinks <- ch_wbt_removesinks(dem_raster_file, no_sink_raster_file, method = "fill")

  # get flow accumulations
  flow_acc_file <- tempfile("flow_acc", fileext = ".tif")
  flow_acc <- ch_wbt_flow_accumulation(no_sink_raster_file, flow_acc_file)

  # get pour points
  pourpoint_file <- tempfile("volcano_pourpoints", fileext = ".shp")
  pourpoints <- ch_volcano_pourpoints(pourpoint_file)
  snapped_pourpoint_file <- tempfile("snapped_pourpoints", fileext = ".shp")
  snapped_pourpoints <- ch_wbt_pourpoints(pourpoints, flow_acc_file, pourpoint_file,
  snapped_pourpoint_file, snap_dist = 10)

  # get flow directions
  flow_dir_file <- tempfile("flow_dir", fileext = ".tif")
  flow_dir <- ch_wbt_flow_direction(no_sink_raster_file, flow_dir_file)
  fn_catchment_ras <- tempfile("catchment", fileext = ".tif")
  fn_catchment_vec <- tempfile("catchment", fileext = ".shp")
  catchments <- ch_wbt_catchment(snapped_pourpoint_file, flow_dir_file, 
  fn_catchment_ras, fn_catchment_vec)
} else {
  message("Examples not run as Whitebox executable not found")
}
}
\seealso{
\code{\link{ch_wbt_catchment_onestep}}
}
\author{
Dan Moore and Kevin Shook
}
