% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireCohortIntersect.R
\name{requireCohortIntersect}
\alias{requireCohortIntersect}
\title{Require cohort subjects are present (or absence) in another cohort}
\usage{
requireCohortIntersect(
  cohort,
  targetCohortTable,
  window,
  intersections = c(1, Inf),
  cohortId = NULL,
  targetCohortId = NULL,
  cohortCombinationCriteria = "all",
  indexDate = "cohort_start_date",
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  censorDate = NULL,
  atFirst = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{targetCohortTable}{Name of the cohort that we want to check for
intersect.}

\item{window}{A list of vectors specifying minimum and maximum days from
\code{indexDate} to consider events over.}

\item{intersections}{A range indicating number of intersections for
criteria to be fulfilled. If a single number is passed, the number of
intersections must match this.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{targetCohortId}{Vector of cohort definition ids to include.}

\item{cohortCombinationCriteria}{Can be 'all', 'any, or a numeric vector
(length 1 or 2) that specifies how many of the target cohorts must meet the
intersection requirement.

Examples:
\itemize{
\item 'all': must meet criteria for each of the target cohorts.
\item 'any': must meet criteria for only one of the target cohorts.
\item Single value: e.g., \code{4}, exactly 4 cohorts must meet the criteria. If
there were 4 target cohorts, this would be the same as 'all'.
\item Range: e.g., \code{c(2, Inf)}, must meet criteria at last 2 of the
target cohorts. Note, \code{c(1, Inf)} is equivalent to 'any'.
}}

\item{indexDate}{Name of the column in the cohort that contains the date to
compute the intersection.}

\item{targetStartDate}{Start date of reference in cohort table.}

\item{targetEndDate}{End date of reference in cohort table. If NULL,
incidence of target event in the window will be considered as intersection,
otherwise prevalence of that event will be used as intersection (overlap
between cohort and event).}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of the cohort.}

\item{atFirst}{If FALSE the requirement will be applied to all records, if
TRUE, it will only be required for the first entry of each subject.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
Cohort table with only those entries satisfying the criteria
}
\description{
\code{requireCohortIntersect()} filters a cohort table based on a requirement
that an individual is seen (or not seen) in another cohort in some time
window around an index date.
}
\examples{
\donttest{
library(CohortConstructor)
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  requireCohortIntersect(targetCohortTable = "cohort2",
                         targetCohortId = 1,
                         indexDate = "cohort_start_date",
                         window = c(-Inf, 0))
}
}
}
