% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hypothesis.R
\name{get_extended_matrix}
\alias{get_extended_matrix}
\title{Extend a matrix to full rank using identity columns}
\usage{
get_extended_matrix(V)
}
\arguments{
\item{V}{A numeric matrix with \code{p} rows and fewer than \code{p} columns.}
}
\value{
A numeric matrix of dimension \verb{p x p} with full column rank.
}
\description{
This function extends a matrix \code{V} (assumed to have fewer than \code{p} columns)
to full rank by iteratively appending standard basis vectors from the identity matrix,
ensuring that each added column increases the rank.
}
\details{
The function assumes that \code{nrow(V)} equals the intended dimension \code{p} of the parameter space.
It adds columns from the identity matrix (i.e., standard basis vectors) only when they increase the rank,
and stops when full rank is achieved.
}
