% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\name{make_data}
\alias{make_data}
\title{Simulate Data}
\usage{
make_data(
  parameters,
  design = NULL,
  n_trials = NULL,
  data = NULL,
  expand = 1,
  staircase = NULL,
  functions = NULL,
  ...
)
}
\arguments{
\item{parameters}{parameter vector used to simulate data.
Can also be a matrix with one row per subject (with corresponding row names)
or an emc object with sampled parameters
(in which case posterior medians of \code{alpha} are used to simulate data)}

\item{design}{Design list created by \code{design()}}

\item{n_trials}{Integer. If \code{data} is not supplied, number of trials to create per design cell}

\item{data}{Data frame. If supplied, the factors are taken from the data. Determines the number of trials per level of the design factors and can thus allow for unbalanced designs}

\item{expand}{Integer. Replicates the \code{data} (if supplied) expand times to increase number of trials per cell.}

\item{staircase}{Default NULL, used with stop-signal paradigm simulation to specify a staircase
algorithm. If non-null and a list then passed through as is, if not it is assigned the
default list structure: list(p=.25,SSD0=.25,stairstep=.05,stairmin=0,stairmax=Inf)}

\item{functions}{List of functions you want to apply to the data generation.}

\item{...}{Additional optional arguments}
}
\value{
A data frame with simulated data
}
\description{
Simulates data based on a model design and a parameter vector (\code{p_vector}) by one of two methods:
\enumerate{
\item Creating a fully crossed and balanced design specified by the design,
with number of trials per cell specified by the \code{n_trials} argument
\item Using the design of a data frame supplied, which allows creation
of unbalanced and other irregular designs, and replacing previous data with
simulated data
}
}
\details{
To create data for multiple subjects see \code{?make_random_effects()}.
}
\examples{
# First create a design
design_DDMaE <- design(factors = list(S = c("left", "right"),
                                           E = c("SPD", "ACC"),
                                           subjects = 1:30),
                            Rlevels = c("left", "right"), model = DDM,
                            formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                            constants=c(s=log(1)))
# Then create a p_vector:
parameters <- c(v_Sleft=-2,v_Sright=2,a=log(1),a_EACC=log(2), t0=log(.2),
              Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))

# Now we can simulate data
data <- make_data(parameters, design_DDMaE, n_trials = 30)

# We can also simulate data based on a specific dataset
design_DDMaE <- design(data = forstmann,model=DDM,
                            formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                            constants=c(s=log(1)))
parameters <- c(v_Sleft=-2,v_Sright=2,a=log(1),a_Eneutral=log(1.5),a_Eaccuracy=log(2),
              t0=log(.2),Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))

data <- make_data(parameters, design_DDMaE, data = forstmann)
}
