% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.bgnlm_model}
\alias{predict.bgnlm_model}
\title{Predict Responses from a BGNLM Model}
\usage{
\method{predict}{bgnlm_model}(
  object,
  x,
  link = function(x) {
     x
 },
  x_train = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{bgnlm_model} object obtained from the BGNLM fitting procedure.
It should contain the estimated coefficients in \code{model$coefs}.}

\item{x}{A \code{data.frame} containing the new data for which predictions are to be made.
The variables in \code{x} must match the features used in the model.}

\item{link}{A link function to apply to the linear predictor.
By default, it is the identity function \code{function(x)\{x\}},
but it can be any function such as \code{plogis} for logistic regression models.}

\item{x_train}{Training design matrix to be provided when imputations are to be made from them}

\item{...}{Additional arguments to pass to prediction function.}
}
\value{
A numeric vector of predicted values for the given data \code{x}.
These predictions are calculated as \eqn{\hat{y} = \text{link}(X \beta)},
where \eqn{X} is the design matrix and \eqn{\beta} are the model coefficients.
}
\description{
This function generates predictions from a fitted \code{bgnlm_model} object given a new dataset.
}
\examples{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet)
preds <- predict(get.best.model(model), exoplanet[,-1])
}
