# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Main function implemented in C++ for the MCMC loop
#'
#' @name run_mcmc
#'
#' @param nIter number of MCMC iterations
#' @param burnin length of MCMC burn-in period
#' @param thin number of thinning
#' @param n number of samples to draw
#' @param nsamp how many samples to draw for generating each sample; only the last draw will be kept
#' @param ninit number of initials as meshgrid values for envelop search
#' @param metropolis value 0/1 for metropolis step or not
#' @param simple logical value for implementing a simple arms algorithm
#' @param convex adjustment for convexity (non-negative value, default 1.0)
#' @param npoint maximum number of envelope points
#' @param dirichlet not yet implemented
#' @param proportion_model logical value for modeling the proportions data
#' @param BVS logical value for implementing Bayesian variable selection
#' @param gamma_prior one of \code{c("bernoulli", "MRF")}
#' @param gamma_sampler one of \code{c("mc3", "bandit")}
#' @param eta_prior one of \code{c("bernoulli", "MRF")}
#' @param eta_sampler one of \code{c("mc3", "bandit")}
#' @param initList a list of initial values for parameters "kappa", "xi", "betas", and "zetas"
#' @param rangeList a list of ranges of initial values for parameters "kappa", "xi", "betas", and "zetas"
#' @param hyperparList a list of relevant hyperparameters
#' @param datEvent a vector of survival status
#' @param datTime a vector of survival times
#' @param datX an array of cluster-specific covariates
#' @param datX0 a matrix of mandatory variables
#' @param datProportionConst an array of cluster-specific proportions
#'
run_mcmc <- function(nIter, burnin, thin, n, nsamp, ninit, metropolis, simple, convex, npoint, dirichlet, proportion_model, BVS, gamma_prior, gamma_sampler, eta_prior, eta_sampler, initList, rangeList, hyperparList, datEvent, datTime, datX, datX0, datProportionConst) {
    .Call(`_GPTCM_run_mcmc`, nIter, burnin, thin, n, nsamp, ninit, metropolis, simple, convex, npoint, dirichlet, proportion_model, BVS, gamma_prior, gamma_sampler, eta_prior, eta_sampler, initList, rangeList, hyperparList, datEvent, datTime, datX, datX0, datProportionConst)
}

