% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{subset.mic_validation}
\alias{subset.mic_validation}
\title{Subset MIC validation object}
\usage{
\method{subset}{mic_validation}(x, subset, ...)
}
\arguments{
\item{x}{mic_validation object}

\item{subset}{logical expression to subset by}

\item{...}{additional arguments}
}
\value{
mic_validation object
}
\description{
Subset MIC validation object
}
\examples{
gold_standard <- c("<0.25", "8", "64", ">64")
test <- c("<0.25", "2", "16", "64")
ab <- AMR::as.ab(c("AMK", "AMK", "CIP", "CIP"))
mo <- AMR::as.mo(c("E. coli", "E. coli", "P. mirabilis", "P. mirabilis"))
val <- compare_mic(gold_standard, test, ab, mo)
subset(val, ab == AMR::as.ab("AMX"))
subset(val, mo == AMR::as.mo("E. coli"))
}
